<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class OrderDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    { 
        
        return [
            'id'             => $this->id,
            'order_id'       => $this->order_id,
            'product_id'     => $this->product_id,
            'product_name'   => $this->product_name,
            'product_code'   => $this->product->product_code,
            'purchase_price' => $this->purchase_price,
            'sale_price'     => $this->sale_price,
            'product_size'   => $this->product_size,
            'product_color'  => $this->product_color,
            'qty'            => $this->qty,
            'color_image'    => $this->color_image, // Accessor auto
            'created_at'     => $this->created_at,
        ];
        
    }
}
