<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\OrderDetailsResource;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'              => $this->id,
            'invoice_id'      => $this->invoice_id,
            'amount'          => $this->amount,
            'discount'        => $this->discount,
            'shipping_charge' => $this->shipping_charge,
            'customer_id'     => $this->customer_id,
            'order_status'    => $this->order_status,
            'note'            => $this->note,
            'created_at'      => $this->created_at,
            'updated_at'      => $this->updated_at,

            // orderdetails collection
            'orderdetails' => OrderDetailsResource::collection(
                $this->orderdetails
            ),
            'shipping' =>$this->shipping,
        ];
    }
}
