@extends('backEnd.layouts.master')
@section('title', 'Landing Page Create')
@section('css')
    <link href="{{asset('public/backEnd')}}/assets/libs/summernote/summernote-lite.min.css" rel="stylesheet"
        type="text/css" />

    <link href="{{asset('public/backEnd')}}/assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
    <link href="{{asset('public/backEnd')}}/assets/libs/flatpickr/flatpickr.min.css" rel="stylesheet" type="text/css" />
@endsection
@section('content')
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <a href="{{route('campaign.index')}}" class="btn btn-primary rounded-pill">Manage</a>
                    </div>
                    <h4 class="page-title">Landing Page Create</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="card">
                    <div class="card-body">
                        <form action="{{route('campaign.store')}}" method="POST" class=row data-parsley-validate=""
                            enctype="multipart/form-data">
                            @csrf


                            <div class="col-sm-12">
                                <div class="form-group mb-3">
                                    <label for="name" class="form-label">Landing Page Title *</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" name="name"
                                        value="{{ old('name') }}" id="name" required="">
                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="image_one" class="form-label">Logo</label>
                                    <input type="file" class="form-control @error('image_one') is-invalid @enderror" name="image_one"
                                         id="image_one">
                                    @error('image_one')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group mb-3">
                                    <label for="banner_title" class="form-label">Banner Title</label>
                                    <input type="text" class="form-control @error('banner_title') is-invalid @enderror"
                                        name="banner_title" id="banner_title">
                                    @error('banner_title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="banner_img" class="form-label">Banner Image</label>
                                    <input type="file" class="form-control @error('banner_img') is-invalid @enderror"
                                        name="banner_img[]" multiple>
                                    @error('banner_img')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group mb-3">
                                    <label for="video" class="form-label">Video </label>
                                    <input type="text" class="form-control @error('video') is-invalid @enderror"
                                        name="video" value="{{ old('video') }}" id="video">
                                    @error('video')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- col-end -->
                            
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="middle_text" class="form-label">Middle Text</label>
                                    <input type="text" class="form-control @error('middle_text') is-invalid @enderror"
                                        name="middle_text">
                                    @error('middle_text')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- col-end -->


                            <!-- col-end -->

                            <div class="col-sm-12">
                                <div class="form-group mb-3">
                                    <label for="product_id" class="form-label">Products *</label>
                                    <select class="select2 form-control @error('product_id') is-invalid @enderror"
                                        value="{{ old('product_id') }}" name="product_id" data-placeholder="Choose ..."
                                        required>

                                        <option value="">Select..</option>
                                        @foreach($products as $value)
                                            <option value="{{$value->id}}">{{$value->name}}</option>
                                        @endforeach

                                    </select>
                                    @error('product_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>


                            <!-- col-end -->
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="short_description" class="form-label">Short Details</label>
                                    <input type="text" class="form-control" name="short_description">
                                    @error('short_description')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="description" class="form-label">Why Product Description</label>
                                    <textarea name="description" rows="6"
                                        class="summernote form-control @error('description') is-invalid @enderror"></textarea>
                                    @error('description')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- col end -->

                            {{-- <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="image_one" class="form-label">Pricing Image One*</label>
                                    <input type="file" class="form-control @error('image_one') is-invalid @enderror "
                                        name="image_one" value="{{ old('image_one') }}" id="image_one" required="">
                                    @error('image_one')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- col end -->

                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="image_two" class="form-label">Pricing Image Two</label>
                                    <input type="file" class="form-control @error('image_two') is-invalid @enderror "
                                        name="image_two" value="{{ old('image_two') }}" id="image_two">
                                    @error('image_two')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- col end -->

                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="image_three" class="form-label">Pricing Image Three</label>
                                    <input type="file" class="form-control @error('image_three') is-invalid @enderror "
                                        name="image_three" value="{{ old('image_three') }}" id="image_three">
                                    @error('image_three')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div> --}}
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="faq_question_one" class="form-label">Faq 1 Question</label>
                                    <input type="text" class="form-control" name="faq_question_one">
                                    @error('faq_question_one')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="faq_answar_one" class="form-label">Faq 1 Answar</label>
                                    <textarea name="faq_answar_one" rows="6"
                                        class="summernote form-control @error('faq_answar_one') is-invalid @enderror"></textarea>
                                    @error('faq_answar_one')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- col end -->
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="faq_question_two" class="form-label">Faq 2 Question (optional)</label>
                                    <input type="text" class="form-control" name="faq_question_two">
                                    @error('faq_question_two')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="faq_answar_two" class="form-label">Faq 2 Answar (optional)</label>
                                    <textarea name="faq_answar_two" rows="6"
                                        class="summernote form-control @error('faq_answar_two') is-invalid @enderror"></textarea>
                                    @error('faq_answar_two')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- col end -->
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="faq_question_three" class="form-label">Faq 3 Question
                                        (optional)</label>
                                    <input type="text" class="form-control" name="faq_question_three">
                                    @error('faq_question_three')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="faq_answar_three" class="form-label">Faq 3 Answar (optional)</label>
                                    <textarea name="faq_answar_three" rows="6"
                                        class="summernote form-control @error('faq_answar_three') is-invalid @enderror"></textarea>
                                    @error('faq_answar_three')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- col end -->
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="faq_question_four" class="form-label">Faq 4 Question
                                        (optional)</label>
                                    <input type="text" class="form-control" name="faq_question_four">
                                    @error('faq_question_four')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="faq_answar_four" class="form-label">Faq 4 Answar (optional)</label>
                                    <textarea name="faq_answar_four" rows="6"
                                        class="summernote form-control @error('faq_answar_four') is-invalid @enderror"></textarea>
                                    @error('faq_answar_four')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- col end -->
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="faq_question_five" class="form-label">Faq 5 Question
                                        (optional)</label>
                                    <input type="text" class="form-control" name="faq_question_five">
                                    @error('faq_question_five')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="faq_answar_five" class="form-label">Faq 5 Answar (optional)</label>
                                    <textarea name="faq_answar_five" rows="6"
                                        class="summernote form-control @error('faq_answar_five') is-invalid @enderror"></textarea>
                                    @error('faq_answar_five')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="campaign_review" class="form-label">Campaign Review</label>
                                    <input type="file" name="campaign_review[]" class="form-control" multiple>
                                    @error('campaign_review')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- clone_price end -->
                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="review" class="form-label">Package Title</label>
                                    <input type="text" class="form-control" name="review">
                                    @error('review')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-sm-12 mb-3">
                                <div class="form-group">
                                    <label for="status" class="d-block">Status</label>
                                    <label class="switch">
                                        <input type="checkbox" value="1" name="status" checked>
                                        <span class="slider round"></span>
                                    </label>
                                    @error('status')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- col end -->
                            <div>
                                <input type="submit" class="btn btn-success" value="Submit">
                            </div>

                        </form>

                    </div> <!-- end card-body-->
                </div> <!-- end card-->
            </div> <!-- end col-->
        </div>
    </div>
@endsection


@section('script')
    <script src="{{asset('public/backEnd/')}}/assets/libs/parsleyjs/parsley.min.js"></script>
    <script src="{{asset('public/backEnd/')}}/assets/js/pages/form-validation.init.js"></script>
    <script src="{{asset('public/backEnd/')}}/assets/libs/select2/js/select2.min.js"></script>
    <script src="{{asset('public/backEnd/')}}/assets/js/pages/form-advanced.init.js"></script>
    <script src="{{asset('public/backEnd/')}}/assets/libs/flatpickr/flatpickr.min.js"></script>
    <script src="{{asset('public/backEnd/')}}/assets/js/pages/form-pickers.init.js"></script>

    <script src="{{asset('public/backEnd/')}}/assets/libs//summernote/summernote-lite.min.js"></script>
    <script>
        $(".summernote").summernote({
            placeholder: "Enter Your Text Here",
        });
    </script>
    <script type="text/javascript">
        $(document).ready(function () {
            $(".btn-increment").click(function () {
                var html = $(".clone").html();
                $(".increment").after(html);
            });
            $("body").on("click", ".btn-danger", function () {
                $(this).parents(".control-group").remove();
            });
            $('.select2').select2();
        });
    </script>
@endsection
