<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="csrf-token" content="{{ csrf_token() }}" />
        <title>@yield('title') - {{$generalsetting->name}}</title>
        <!-- App favicon -->

        <link rel="shortcut icon" href="{{asset($generalsetting->favicon)}}" alt="Super Ecommerce Favicon" />
        <meta name="author" content="Super Ecommerce" />
        <link rel="canonical" href="" />
        @stack('seo')
        @stack('css')
        <link rel="stylesheet" href="{{asset('public/frontEnd/css/bootstrap.min.css')}}" />
        <link rel="stylesheet" href="{{asset('public/frontEnd/css/animate.css')}}" />
        <link rel="stylesheet" href="{{asset('public/frontEnd/css/all.min.css')}}" />
        <link rel="stylesheet" href="{{asset('public/frontEnd/css/owl.carousel.min.css')}}" />
        <link rel="stylesheet" href="{{asset('public/frontEnd/css/owl.theme.default.min.css')}}" />
        <link rel="stylesheet" href="{{asset('public/frontEnd/css/mobile-menu.css')}}" />
        <link rel="stylesheet" href="{{asset('public/frontEnd/css/select2.min.css')}}" />
        <!-- toastr css -->
        <link rel="stylesheet" href="{{asset('public/backEnd/')}}/assets/css/toastr.min.css" />

        <link rel="stylesheet" href="{{asset('public/frontEnd/css/wsit-menu.css')}}" />
        <link rel="stylesheet" href="{{asset('public/frontEnd/css/style.css')}}" />
        <link rel="stylesheet" href="{{asset('public/frontEnd/css/responsive.css')}}" />
        <link rel="stylesheet" href="{{asset('public/frontEnd/css/main.css')}}" />

        <meta name="facebook-domain-verification" content="38f1w8335btoklo88dyfl63ba3st2e" />

        @foreach($pixels as $pixel)
        <!-- Facebook Pixel Code -->
        <script>
            !(function (f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function () {
                    n.callMethod ? n.callMethod.apply(n, arguments) : n.queue.push(arguments);
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = "2.0";
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s);
            })(window, document, "script", "https://connect.facebook.net/en_US/fbevents.js");
            fbq("init", "{{{$pixel->code}}}");
            fbq("track", "PageView");
        </script>
        <noscript>
            <img height="1" width="1" style="display: none;" src="https://www.facebook.com/tr?id={{{$pixel->code}}}&ev=PageView&noscript=1" />
        </noscript>
        <!-- End Facebook Pixel Code -->
        @endforeach

        @foreach($gtm_code as $gtm)
        <!-- Google tag (gtag.js) -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-{{ $gtm->code }}');</script>
        <!-- End Google Tag Manager -->
        @endforeach
        
        <style>
            #message {
                display: none;
            }
            
            .cat_bar::before {
                content: "";
                position: absolute;
                top: 100%;
                left: -10px;
                width: 0;
                height: 2px;
                background: #fc630a;
                transition: 0.3s;
            }
            .cat_bar::after {
                content: "";
                width: 2px;
                height: 100%;
                background: #c9c6c6;
                position: absolute;
                right: 0;
                top: 0;
                transform: rotate(20deg);
            }
            .product_sliders {
              display: grid;
              grid-template-columns: repeat(7, 1fr) !important;
              grid-gap: 20px !important;
            }
            @media only screen and (min-width: 320px) and (max-width: 767px) {
                .product_sliders {
                    grid-template-columns: repeat(2, 1fr) !important;
                    grid-gap: 10px;
                }
            }
        </style>
    </head>
    <body class="gotop">
        @php $subtotal = Cart::instance('shopping')->subtotal(); @endphp
        <div class="mobile-menu">
                <div class="mobile-menu-logo">
                    <div class="logo-image">
                        <img src="{{asset($generalsetting->white_logo)}}" alt="" />
                    </div>
                    <div class="mobile-menu-close">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <ul class="first-nav">
                    @foreach($menucategories as $scategory)
                    <li class="parent-category">
                        <a href="{{url('category/' . $scategory->slug)}}" class="menu-category-name">
                            <img src="{{asset($scategory->image)}}" alt="" class="side_cat_img" />
                            {{$scategory->name}}
                        </a>
                        @if($scategory->subcategories->count() > 0)
                        <span class="menu-category-toggle">
                            <i class="fa fa-chevron-down"></i>
                        </span>
                        @endif
                        <ul class="second-nav" style="display: none;">
                            @foreach($scategory->subcategories as $subcategory)
                            <li class="parent-subcategory">
                                <a href="{{url('subcategory/' . $subcategory->slug)}}" class="menu-subcategory-name">{{$subcategory->subcategoryName}}</a>
                                @if($subcategory->childcategories->count() > 0)
                                <span class="menu-subcategory-toggle"><i class="fa fa-chevron-down"></i></span>
                                @endif
                                <ul class="third-nav" style="display: none;">
                                    @foreach($subcategory->childcategories as $childcat)
                                    <li class="childcategory"><a href="{{url('products/' . $childcat->slug)}}" class="menu-childcategory-name">{{$childcat->childcategoryName}}</a></li>
                                    @endforeach
                                </ul>
                            </li>
                            @endforeach
                        </ul>
                    </li>
                    @endforeach
                </ul>
            </div>
        <header id="navbar_top">
            <div class="mobile-header sticky">
                <div class="mobile-logo">
                    <div class="menu-bar">
                        <a class="toggle">
                            <i class="fa-solid fa-bars"></i>
                        </a>
                    </div>
                    <div class="menu-logo">
                        <a href="{{route('home')}}"><img src="{{asset($generalsetting->white_logo)}}" alt="" /></a>
                    </div>
                    <div class="menu-bag">
                        <a href="{{url('customer/login')}}">
                            <p class="margin-shopping" >
                                <i class="fa-regular fa-user"></i> 
                            </p>
                        </a>
                        <p class="margin-shopping" >
                            <i class="fa-solid fa-cart-shopping"></i>
                            <span class="mobilecart-qty">{{Cart::instance('shopping')->count()}}</span>
                        </p>
                    </div>
                    
                </div>
            </div>

            <div class="mobile-search">
                <form action="{{route('search')}}">
                    <input type="text" placeholder="Search Product ... " value="" class="msearch_keyword msearch_click" name="keyword" />
                    <button><i data-feather="search"></i></button>
                </form>
                <div class="search_result"></div>
            </div>

         


            <div class="main-header">
                <!-- header to end -->
                <div class="logo-area">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="logo-header">
                                    <div class="main-logo">
                                        <a href="{{route('home')}}"><img src="{{asset($generalsetting->white_logo)}}" alt="" /></a>
                                    </div>
                                    <div class="main-search">
                                        <form action="{{route('search')}}">
                                            <input type="text" placeholder="Search Product..." class="search_keyword search_click" name="keyword" />
                                            <button>
                                                <i data-feather="search"></i>
                                            </button>
                                        </form>
                                        <div class="search_result"></div>
                                    </div>
                                    <div class="header-list-items">
                                        <ul style="margin-top: 3px;">
                                            <li class="track_btn" style="background: #ff6700;padding: 8px;border-radius: 6px;">
                                                <a href="tel:+88{{$contact->phone}}" style="color:white;"> <i class="fa fa-phone"></i> {{$contact->phone}}</a>
                                            </li>
                                            @if(Auth::guard('customer')->user())
                                            <li class="for_order" style="background: #ff6700;padding: 8px 14px;border-radius: 6px;">
                                                <p>
                                                    <a href="{{route('customer.account')}}" style="color:white;" >
                                                        <i class="fa-regular fa-user"></i> 
                                                    </a>
                                                </p>
                                            </li>
                                            @else
                                            <li class="for_order" style="background: #ff6700;padding: 8px 14px;border-radius: 6px;">
                                                <p>
                                                    <a href="{{route('customer.login')}}" style="color:white;">
                                                        <i class="fa-regular fa-user"></i> 
                                                    </a>
                                                </p>
                                            </li>
                                            @endif

                                            <li class="cart-dialog" id="cart-qty" style="background: #ff6700;padding: 7px 6px;border-radius: 6px;">
                                                <a href="{{route('customer.checkout')}}">
                                                    <p class="margin-shopping">
                                                        <i class="fa-solid fa-cart-shopping" style="color: white;"></i>
                                                        <span>{{Cart::instance('shopping')->count()}}</span>
                                                    </p>
                                                </a>
                                                <div class="cshort-summary">
                                                    <ul>
                                                        @foreach(Cart::instance('shopping')->content() as $key => $value)
                                                        <li>
                                                            <a href=""><img src="{{asset($value->options->image)}}" alt="" /></a>
                                                        </li>
                                                        <li><a href="">{{Str::limit($value->name, 30)}}</a></li>
                                                        <li>Qty: {{$value->qty}}</li>
                                                        <li>
                                                            <p>৳{{$value->price}}</p>
                                                            <button class="remove-cart cart_remove" data-id="{{$value->rowId}}"><i data-feather="x"></i></button>
                                                        </li>
                                                        @endforeach
                                                    </ul>
                                                    <p><strong>সর্বমোট : ৳{{$subtotal}}</strong></p>
                                                    <a href="{{route('customer.checkout')}}" class="go_cart"> অর্ডার করুন </a>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="menu-area" style="background:#d3d3d3">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="catagory_menu">
                                    <ul>
                                        <li class="cat_bar ">
                                            <a href="{{ url('/') }}" style="background:#d3d3d3;color:black">
                                                <i class="fa-solid fa-home"></i>
                                                <span class="cat_head">HOME</span> 
                                            </a> 
                                        </li>
                                        <li class="cat_bar ">
                                            <a href="#" style="background:#d3d3d3;color:black">
                                                <i class="fa-solid fa-bars"></i>
                                                <span class="cat_head">CATEGORIES</span>
                                                 
                                                <i class="fa-solid fa-angle-down cat_down"></i>
                                                
                                            </a>
                                             
                                            <ul class="Cat_menu">
                                                @foreach ($menucategories as $scategory)
                                                <li class="Cat_list cat_list_hover">
                                                    <a href="{{ url('category/' . $scategory->slug) }}">
                                                        <span>{{ $scategory->name }}</span>
                                                        @if($scategory->subcategories->count() > 0)<i class="fa-solid fa-chevron-right cat_down"></i>@endif
                                                    </a>
                                                    @if($scategory->subcategories->count() > 0)
                                                    <ul class="child_menu">
                                                        @foreach ($scategory->subcategories as $subcat)
                                                        <li class="child_main">
                                                            <a href="{{ url('subcategory/' . $subcat->slug) }}">{{ Str::limit($subcat->subcategoryName, 25) }}</a>

                                                        </li>
                                                        @endforeach
                                                    </ul>
                                                    @endif
                                                </li>
                                                @endforeach
                                            </ul>
                                             
                                        </li>
                                        
                                        <li class="cat_bar ">
                                            <a href="{{ url('/') }}" style="background:#d3d3d3;color:black">
                                                <i class="fa-solid fa-tag"></i>
                                                <span class="cat_head">TOP SELLING</span> 
                                            </a> 
                                        </li>
                                        <li class="cat_bar ">
                                            <a href="{{ url('/') }}" style="background:#d3d3d3;color:black">
                                                <i class="fa-solid fa-shop"></i>
                                                <span class="cat_head">NEW PRODUCT</span> 
                                            </a> 
                                        </li>
                                        <li class="cat_bar ">
                                            <a href="{{ url('/') }}" style="background:#d3d3d3;color:black">
                                                <i class="fa-solid fa-bolt"></i>
                                                <span class="cat_head">FLASH SELL</span> 
                                            </a> 
                                        </li>
                                        
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- main-header end -->
        </header>
        <div id="content">
            @yield('content')
        </div>
            <!-- content end -->
        <div class="container-fluid">  
            <div class="row service-support-box"> 
                <div class="col-lg-3 col-md-6 col-6 border-end mb-3">
                    <div class="support service-support-single d-flex align-items-center ps-lg-4">
                        <!--<img width="40" height="40" src="https://img.icons8.com/ios/40/marker--v1.png" alt="marker--v1"/>-->
                        <img src="{{asset('public/')}}/Free%20Delivery17112665361734178775.png" width="30" height="30">
                        <div class="" style="margin: 5px;padding: 0px;">
                        <h6 style="margin:0px"><strong>Free Delivery</strong></h6>
                            <p class="font-13 m-0">
                                On all order above BDT 5000
                            </p>
                        </div>
                   </div>
                </div> 
                <div class="col-lg-3 col-md-6 col-6 border-end mb-3">
                    <div class="support service-support-single d-flex align-items-center ps-lg-4">
                        <!--<img width="30" height="30" src="https://img.icons8.com/ios/30/return.png" alt="return"/>-->
                        <img src="{{asset('public/')}}/Guaranty1711266536.png" width="30" height="30">
                        <div class="" style="margin: 5px;padding: 0px;">
                            <h6 style="margin:0px"><strong>7 days return</strong></h6>
                            <p class="font-13 m-0">
                                7 days Easy return Guaranty
                            </p>
                        </div>
                    </div>
                </div> 
                <div class="col-lg-3 col-md-6 col-6 border-end mb-3">
                  <div class="support service-support-single d-flex align-items-center ps-lg-4">
                     <!--<img width="50" height="50" src="https://img.icons8.com/ios/50/geography--v1.png" alt="geography--v1"/>-->
                     <img src="{{asset('public/')}}/geography--v11711266536.png" width="30" height="30">
                     <div class="" style="margin: 5px;padding: 0px;">
                        <h6 style="margin:0px"><strong>Warranty</strong></h6>
                        <p class="font-13 m-0">
                           1 year official warranty
                        </p>
                     </div>
                  </div>
               </div> 
                <div class="col-lg-3 col-md-6 col-6 mb-3">
                  <div class="support service-support-single d-flex align-items-center ps-lg-4"> 
                     <img src="{{asset('public/')}}/payment1711266536.png" width="30" height="30">
                     <div class="" style="margin: 5px;padding: 0px;">
                        <h6 style="margin:0px"><strong>100% Secure</strong></h6>
                        <p class="font-13 m-0">
                          COD/Mobile banking/visa
                        </p>
                     </div>
                  </div>
               </div>
            </div> 
        </div>

        <footer>
            <div class="footer-top">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-4 mb-3 mb-sm-0">
                            <div class="footer-about">
                                <a href="{{route('home')}}">
                                    <img src="{{asset($generalsetting->white_logo)}}" alt="" />
                                </a>
                                <p>{{$contact->address}}</p>
                                <a href="tel:{{$contact->hotline}}" class="footer-hotlint">{{$contact->hotline}}</a>
                            </div>
                        </div>
                        <!-- col end -->
                        <div class="col-sm-3 mb-3 mb-sm-0 col-6">
                            <div class="footer-menu">
                                <ul>
                                    <li class="title"><a>Useful Link</a></li>
                                    <li>
                                        <a href="{{route('contact')}}"> <a href="{{route('contact')}}">Contact Us</a></a>
                                    </li>
                                    @foreach($pages as $page)
                                    <li><a href="{{route('page', ['slug' => $page->slug])}}">{{$page->name}}</a></li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <!-- col end -->
                        <div class="col-sm-2 mb-3 mb-sm-0 col-6">
                            <div class="footer-menu">
                                <ul>
                                    <li class="title"><a>Link</a></li>
                                    @foreach($pagesright as $key => $value)
                                    <li>
                                        <a href="{{route('page', ['slug' => $value->slug])}}">{{$value->name}}</a>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>

                        <!-- col end -->
                        <div class="col-sm-3 mb-3 mb-sm-0">
                            <div class="footer-menu">
                                <ul>
                                    <li class="title stay_conn"><a>Stay Connected</a></li>
                                </ul>
                                <ul class="social_link">
                                    @foreach($socialicons as $value)
                                    <li class="social_list">
                                        <a class="mobile-social-link" href="{{$value->link}}"><i class="{{$value->icon}}"></i></a>
                                    </li>
                                    @endforeach
                                </ul>
                                <div class="d_app">
                                    <h2>Download App</h2>
                                    <a href="">
                                        <img src="{{asset('public/frontEnd/images/app-download.png')}}" alt="" />
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!-- col end -->
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="copyright">
                                <p>Copyright © {{ date('Y') }} {{$generalsetting->name}}. All rights reserved.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>

        <div class="footer_nav">
            <ul>
                <li>
                    <a class="toggle">
                        <span>
                            <i class="fa-solid fa-bars"></i>
                        </span>
                        <span>Category</span>
                    </a>
                </li>

                <li>
                    <a href="https://wa.me/8801716170203">
                        <span>
                            <i class="fa-solid fa-message"></i>
                        </span>
                        <span>Message</span>
                    </a>
                </li>

                <li class="mobile_home">
                    <a href="{{route('home')}}">
                        <span><i class="fa-solid fa-home"></i></span> <span>Home</span>
                    </a>
                </li>

                <li>
                    <a href="{{route('customer.checkout')}}">
                        <span>
                            <i class="fa-solid fa-cart-shopping"></i>
                        </span>
                        <span>Cart (<b class="mobilecart-qty">{{Cart::instance('shopping')->count()}}</b>)</span>
                    </a>
                </li>
                @if(Auth::guard('customer')->user())
                <li>
                    <a href="{{route('customer.account')}}">
                        <span>
                            <i class="fa-solid fa-user"></i>
                        </span>
                        <span>Account</span>
                    </a>
                </li>
                @else
                <li>
                    <a href="{{route('customer.login')}}">
                        <span>
                            <i class="fa-solid fa-user"></i>
                        </span>
                        <span>Login</span>
                    </a>
                </li>
                @endif
            </ul>
        </div>
        
       
         <div id="message">
    
            <a href="https://wa.me/{{ $contact->phone }}?text=I%20am%20interested" target="_blank" style="position: fixed;bottom: 210px;right: 6px;z-index:1111">
                <img src="{{asset('public/whatsapp.png')}}" style="height:60px;border-radius:50%">
            </a>
            <a href="tel:{{ $contact->phone }}" target="_blank" style="position: fixed;bottom: 135px;right: 6px;z-index:1111">
                <img src="{{asset('public/telephone.png')}}" style="height:60px;border-radius:50%">
            </a>
        </div>
    
        <a href="javascript:void(0);" class="d-block" onclick="showmessage()" id="showm" style="position: fixed;bottom: 60px;right: 6px;z-index:1111">
            <img src="{{asset('public/livec-removebg-preview.png')}}" style="height:60px;" id="shimg">
        </a>
        <a href="javascript:void(0);" onclick="hidemessage()" id="crossm" style="position: fixed;bottom: 60px;right: 6px;z-index:1111">
            <img src="{{asset('public/livec-removebg-preview.png')}}" style="height:60px;" id="crimg">
        </a>
        
       

        <!-- /. fixed sidebar -->

        <div id="custom-modal"></div>
        <div id="page-overlay"></div>
        <div id="loading"><div class="custom-loader"></div></div>


        <style>
            /* Overlay Background */
            .popup-overlay {
                position: fixed;
                inset: 0;
                /*background-color: rgba(0, 0, 0, 0.5);*/
                z-index: 999;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            /* Popup Box */
            .popup {
                position: relative;
                background: #fff;
                border-radius: 8px;
                max-width: 90%;
                max-height: 90%;
                padding: 20px;
                box-shadow: 0 0 20px rgba(0, 0, 0, 0.2);
                animation: fadeIn 0.4s ease-in-out;
            }

            /* Close Button */
            .popup .close-btn {
                position: absolute;
                top: 10px;
                right: 14px;
                font-size: 24px;
                font-weight: bold;
                color: #333;
                cursor: pointer;
                background: none;
                border: none;
            }

            .popup img {
                max-width: 100%;
                height: auto;
                border-radius: 6px;
            }

            @keyframes fadeIn {
                from {
                    opacity: 0;
                    transform: scale(0.95);
                }

                to {
                    opacity: 1;
                    transform: scale(1);
                }
            }
            .popup_long_Image{
                width: 400px; 
                height:400px;
                object-fit: contain;
            }
            @media only screen and (min-width:320px) and (max-width:767px) {
                .popup_long_Image{
                height:340px;
            }
        </style>
        @php
        $setting = App\Models\GeneralSetting::first();
        @endphp
        <!-- Popup Overlay -->
        @if ($setting->popup_image)
            <div id="popupOverlay" class="popup-overlay mt-5" style="display: none; z-index: 9999;">
                <div class="popup">
                    <div class="text-center" style="padding-bottom:10px;">
                        <img src="{{ asset($setting->white_logo) }}" alt="" width="80">
                    </div>
                    <button class="close-btn fs-1" onclick="closePopup()" style="width: 50px">&times; </button> 
                    <a href="{{ $setting->popup_link }}" onclick="markPopupAsClicked()">
                        <img src="{{ asset($setting->popup_image) }}" style=" height:80%" class="popup_long_Image" alt="Popup Image" />
                    </a>
                </div>
            </div>
        @endif
        
        <script>
            function closePopup() {
                document.getElementById("popupOverlay").style.display = "none";
                sessionStorage.setItem("popupClosed", "true"); // Mark as closed
            }
        
            function markPopupAsClicked() {
                // Mark the popup as clicked so it doesn't show again after clicking the link
                sessionStorage.setItem("popupClosed", "true");
            }
        
            window.onload = function () {
                const popup = document.getElementById("popupOverlay");
        
                // Only show the popup if it has not been closed yet
                if (!sessionStorage.getItem("popupClosed")) {
                    popup.style.display = "flex"; // Show the popup
                }
            };
            
            function showmessage(){
                $('#showm').css('display','none');
                $('#showms').css('display','none');
                $('#crossms').css('display','inline');
                $('#crossm').css('display','inline');
                $("#message").fadeIn('slow');
            }
            function hidemessage(){
                $('#showm').css('display','inline');
                $('#showms').css('display','inline');
                $('#crossms').css('display','none');
                $('#crossm').css('display','none');
                $("#message").fadeOut('slow');
            }
            
        </script>


        <script src="{{asset('public/frontEnd/js/jquery-3.6.3.min.js')}}"></script>
        <script src="{{asset('public/frontEnd/js/bootstrap.min.js')}}"></script>
        <script src="{{asset('public/frontEnd/js/owl.carousel.min.js')}}"></script>
        <script src="{{asset('public/frontEnd/js/mobile-menu.js')}}"></script>
        <script src="{{asset('public/frontEnd/js/wsit-menu.js')}}"></script>
        <script src="{{asset('public/frontEnd/js/mobile-menu-init.js')}}"></script>
        <script src="{{asset('public/frontEnd/js/wow.min.js')}}"></script>
        <script>
            new WOW().init();
        </script>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css" />
        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

        <!-- feather icon -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/feather-icons/4.29.0/feather.min.js"></script>
        <script>
            feather.replace();
        </script>
        <script src="{{asset('public/backEnd/')}}/assets/js/toastr.min.js"></script>
        {!! Toastr::message() !!} @stack('script')
        <script>
            $(".quick_view").on("click", function () {
                var id = $(this).data("id");
                $("#loading").show();
                if (id) {
                    $.ajax({
                        type: "GET",
                        data: { id: id },
                        url: "{{route('quickview')}}",
                        success: function (data) {
                            if (data) {
                                $("#custom-modal").html(data);
                                $("#custom-modal").show();
                                $("#loading").hide();
                                $("#page-overlay").show();
                            }
                        },
                    });
                }
            });
        </script>
        <!-- quick view end -->
        <!-- cart js start -->
        <script>
            $(".addcartbutton").on("click", function () {
                var id = $(this).data("id");
                var qty = 1;
                if (id) {
                    $.ajax({
                        cache: "false",
                        type: "GET",
                        url: "{{url('add-to-cart')}}/" + id + "/" + qty,
                        dataType: "json",
                        success: function (data) {
                            if (data) {
                                toastr.success('Success', 'Product add to cart successfully');
                                return cart_count() + mobile_cart();
                            }
                        },
                    });
                }
            });
            $(".cart_store").on("click", function () {
                var id = $(this).data("id");
                var qty = $(this).parent().find("input").val();
                if (id) {
                    $.ajax({
                        type: "GET",
                        data: { id: id, qty: qty ? qty : 1 },
                        url: "{{route('cart.store')}}",
                        success: function (data) {
                            if (data) {
                                toastr.success('Success', 'Product add to cart succfully');
                                return cart_count() + mobile_cart();
                            }
                        },
                    });
                }
            });

            $(".cart_remove").on("click", function () {
                var id = $(this).data("id");
                if (id) {
                    $.ajax({
                        type: "GET",
                        data: { id: id },
                        url: "{{route('cart.remove')}}",
                        success: function (data) {
                            if (data) {
                                $(".cartlist").html(data);
                                return cart_count() + mobile_cart() + cart_summary();
                            }
                        },
                    });
                }
            });

            $(".cart_increment").on("click", function () {
                var id = $(this).data("id");
                if (id) {
                    $.ajax({
                        type: "GET",
                        data: { id: id },
                        url: "{{route('cart.increment')}}",
                        success: function (data) {
                            if (data) {
                                $(".cartlist").html(data);
                                return cart_count() + mobile_cart();
                            }
                        },
                    });
                }
            });

            $(".cart_decrement").on("click", function () {
                var id = $(this).data("id");
                if (id) {
                    $.ajax({
                        type: "GET",
                        data: { id: id },
                        url: "{{route('cart.decrement')}}",
                        success: function (data) {
                            if (data) {
                                $(".cartlist").html(data);
                                return cart_count() + mobile_cart();
                            }
                        },
                    });
                }
            });

            function cart_count() {
                $.ajax({
                    type: "GET",
                    url: "{{route('cart.count')}}",
                    success: function (data) {
                        if (data) {
                            $("#cart-qty").html(data);
                        } else {
                            $("#cart-qty").empty();
                        }
                    },
                });
            }
            function mobile_cart() {
                $.ajax({
                    type: "GET",
                    url: "{{route('mobile.cart.count')}}",
                    success: function (data) {
                        if (data) {
                            $(".mobilecart-qty").html(data);
                        } else {
                            $(".mobilecart-qty").empty();
                        }
                    },
                });
            }
            function cart_summary() {
                $.ajax({
                    type: "GET",
                    url: "{{route('shipping.charge')}}",
                    dataType: "html",
                    success: function (response) {
                        $(".cart-summary").html(response);
                    },
                });
            }
        </script>
        <!-- cart js end -->
        <script>
            $(".search_click").on("keyup change", function () {
                var keyword = $(".search_keyword").val();
                $.ajax({
                    type: "GET",
                    data: { keyword: keyword },
                    url: "{{route('livesearch')}}",
                    success: function (products) {
                        if (products) {
                            $(".search_result").html(products);
                        } else {
                            $(".search_result").empty();
                        }
                    },
                });
            });
            $(".msearch_click").on("keyup change", function () {
                var keyword = $(".msearch_keyword").val();
                $.ajax({
                    type: "GET",
                    data: { keyword: keyword },
                    url: "{{route('livesearch')}}",
                    success: function (products) {
                        if (products) {
                            $("#loading").hide();
                            $(".search_result").html(products);
                        } else {
                            $(".search_result").empty();
                        }
                    },
                });
            });
        </script>
        <!-- search js start -->
        <script></script>
        <script></script>
        <script>
            $(".district").on("change", function () {
                var id = $(this).val();
                $.ajax({
                    type: "GET",
                    data: { id: id },
                    url: "{{route('districts')}}",
                    success: function (res) {
                        if (res) {
                            $(".area").empty();
                            $(".area").append('<option value="">Select..</option>');
                            $.each(res, function (key, value) {
                                $(".area").append('<option value="' + key + '" >' + value + "</option>");
                            });
                        } else {
                            $(".area").empty();
                        }
                    },
                });
            });
        </script>
        <script>
            $(".toggle").on("click", function () {
                $("#page-overlay").show();
                $(".mobile-menu").addClass("active");
            });

            $("#page-overlay").on("click", function () {
                $("#page-overlay").hide();
                $(".mobile-menu").removeClass("active");
                $(".feature-products").removeClass("active");
            });

            $(".mobile-menu-close").on("click", function () {
                $("#page-overlay").hide();
                $(".mobile-menu").removeClass("active");
            });

            $(".mobile-filter-toggle").on("click", function () {
                $("#page-overlay").show();
                $(".feature-products").addClass("active");
            });
        </script>
        <script>
            $(document).ready(function () {
                $(".parent-category").each(function () {
                    const menuCatToggle = $(this).find(".menu-category-toggle");
                    const secondNav = $(this).find(".second-nav");

                    menuCatToggle.on("click", function () {
                        menuCatToggle.toggleClass("active");
                        secondNav.slideToggle("fast");
                        $(this).closest(".parent-category").toggleClass("active");
                    });
                });
                $(".parent-subcategory").each(function () {
                    const menuSubcatToggle = $(this).find(".menu-subcategory-toggle");
                    const thirdNav = $(this).find(".third-nav");

                    menuSubcatToggle.on("click", function () {
                        menuSubcatToggle.toggleClass("active");
                        thirdNav.slideToggle("fast");
                        $(this).closest(".parent-subcategory").toggleClass("active");
                    });
                });
            });
        </script>

        <script>
            var menu = new MmenuLight(document.querySelector("#menu"), "all");

            var navigator = menu.navigation({
                selectedClass: "Selected",
                slidingSubmenus: true,
                // theme: 'dark',
                title: "ক্যাটাগরি",
            });

            var drawer = menu.offcanvas({
                // position: 'left'
            });

            //  Open the menu.
            document.querySelector('a[href="#menu"]').addEventListener("click", (evnt) => {
                evnt.preventDefault();
                drawer.open();
            });
        </script>

        <script>
            // document.addEventListener("DOMContentLoaded", function () {
            //     window.addEventListener("scroll", function () {
            //         if (window.scrollY > 200) {
            //             document.getElementById("navbar_top").classList.add("fixed-top");
            //         } else {
            //             document.getElementById("navbar_top").classList.remove("fixed-top");
            //             document.body.style.paddingTop = "0";
            //         }
            //     });
            // });
            /*=== Main Menu Fixed === */
            // document.addEventListener("DOMContentLoaded", function () {
            //     window.addEventListener("scroll", function () {
            //         if (window.scrollY > 0) {
            //             document.getElementById("m_navbar_top").classList.add("fixed-top");
            //             // add padding top to show content behind navbar
            //             navbar_height = document.querySelector(".navbar").offsetHeight;
            //             document.body.style.paddingTop = navbar_height + "px";
            //         } else {
            //             document.getElementById("m_navbar_top").classList.remove("fixed-top");
            //             // remove padding top from body
            //             document.body.style.paddingTop = "0";
            //         }
            //     });
            // });
            /*=== Main Menu Fixed === */

            $(window).scroll(function () {
                if ($(this).scrollTop() > 50) {
                    $(".scrolltop:hidden").stop(true, true).fadeIn();
                } else {
                    $(".scrolltop").stop(true, true).fadeOut();
                }
            });
            $(function () {
                $(".scroll").click(function () {
                    $("html,body").animate({ scrollTop: $(".gotop").offset().top }, "1000");
                    return false;
                });
            });
        </script>
        <script>
            $(".filter_btn").click(function(){
               $(".filter_sidebar").addClass('active');
               $("body").css("overflow-y", "hidden");
            })
            $(".filter_close").click(function(){
               $(".filter_sidebar").removeClass('active');
               $("body").css("overflow-y", "auto");
            })
        </script>
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-K29C9BKJ"
        height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
    </body>
</html>
