@extends('frontEnd.layouts.master')
@section('title', $details->name)
@push('seo')
    <meta name="app-url" content="{{ route('product', $details->slug) }}" />
    <meta name="robots" content="index, follow" />
    <meta name="description" content="{{ $details->meta_description }}" />
    <meta name="keywords" content="{{ $details->slug }}" />

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="product" />
    <meta name="twitter:site" content="{{ $details->name }}" />
    <meta name="twitter:title" content="{{ $details->name }}" />
    <meta name="twitter:description" content="{{ $details->meta_description }}" />
    <meta name="twitter:creator" content="gomobd.com" />
    <meta property="og:url" content="{{ route('product', $details->slug) }}" />
    <meta name="twitter:image" content="{{ asset($details->image->image) }}" />

    <!-- Open Graph data -->
    <meta property="og:title" content="{{ $details->name }}" />
    <meta property="og:type" content="product" />
    <meta property="og:url" content="{{ route('product', $details->slug) }}" />
    <meta property="og:image" content="{{ asset($details->image->image) }}" />
    <meta property="og:description" content="{{ $details->meta_description }}" />
    <meta property="og:site_name" content="{{ $details->name }}" />
@endpush

@push('css')
    <link rel="stylesheet" href="{{ asset('public/frontEnd/css/zoomsl.css') }}">
@endpush

@section('content')
<style>
    
    .accordion {
      width: 100%;
      border-top: 1px solid #ccc;
    }

    .accordion-item {
        border:none;
      border-bottom: 1px solid #ccc;
      padding: 15px 10px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      cursor: pointer;
    }

    .accordion-item .left {
      display: flex;
      align-items: center;
      gap: 12px;
    }

    .accordion-item .icon-box {
      background: #d5fbe0;
      padding: 10px;
      border-radius: 8px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 20px;
    }

    .accordion-item h4 {
      margin: 0;
      font-size: 18px;
      font-weight: bold;
    }

    .accordion-item p {
      margin: 0;
      font-size: 14px;
      color: #555;
    }

    .accordion-toggle {
      font-size: 20px;
      font-weight: bold;
      transition: transform 0.2s;
    }

    .accordion-content {
      display: none;
      padding: 10px 45px;
      font-size: 14px;
      color: #333;
      background: #fafafa;
    }

    .accordion-item.active .accordion-toggle::after {
      content: "–";
    }

    .accordion-item:not(.active) .accordion-toggle::after {
      content: "+";
    }
    
    .color_inner {
        display: flex;
        margin-top: -5px;
    }
    .size_inner {
        display: flex;
        margin-top: -4px;
    }
    
    .selector {
        display: flex;
        flex-wrap: wrap; /* জায়গা শেষ হলে নিচে যাবে */
        gap: 10px; /* আইটেমের মধ্যে ফাঁক */
    }
    
    .selector-item {
        display: flex;
        align-items: center;
    } 
</style>
    <div class="homeproduct main-details-page prdetail">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <section class="product-section">
                        <div class="container">
                            <div class="row">
                                <div class="col-sm-6 position-relative">
                                    @if($details->old_price)
                                        <div class="product-details-discount-badge">
                                            <div class="sale-badge">
                                                <div class="sale-badge-inner">
                                                    <div class="sale-badge-box">
                                                        <span class="sale-badge-text">
                                                            <p> @php $discount = (((($details->old_price) - ($details->new_price)) * 100) / ($details->old_price)) @endphp
                                                                {{ number_format($discount, 0) }}% ছাড়
                                                            </p>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                    <div class="details_slider owl-carousel">
                                        @if ($productcolors->count() > 0)
                                            @foreach ($productcolors as $proc)
                                                <div class="dimage_item">
                                                    <img src="{{ asset($proc->Image) }}" class="block__pic" />
                                                </div>
                                            @endforeach
                                        @else
                                            @foreach ($details->images as $value)
                                                <div class="dimage_item">
                                                    <img src="{{ asset($value->image) }}" class="block__pic" />
                                                </div>
                                            @endforeach
                                        @endif
                                        @if(isset($details->PostImage))
                                            @foreach (json_decode($details->PostImage) as $key => $image)
                                                <div class="dimage_item">
                                                    <img src="{{asset('public/images/product/slider')}}/{{$image}}"
                                                        class="block__pic" />
                                                </div>
                                            @endforeach
                                        @endif
                                    </div>
                                    @php
                                $keyidone = 0;
                                $keyidone3 = 0;
                                $keyid = 0;
                            
                                // Total image count calculation
                                $totalImages = 0;
                                if ($productcolors->count() > 0) {
                                    $totalImages += $productcolors->count();
                                } else {
                                    $totalImages += $details->images->count();
                                }
                                if (isset($details->PostImage)) {
                                    $totalImages += count(json_decode($details->PostImage));
                                }
                            
                                $carouselClass = $totalImages > 4 ? 'thumb_slider owl-carousel' : '';
                            @endphp
                            
                            <div class="indicator_thumb {{ $carouselClass }}">
                                {{-- Product Color Images --}}
                                @if ($productcolors->count() > 0)
                                    @foreach ($productcolors as $key => $procs)
                                        <div class="indicator-item item" id="{{ ++$keyidone }}" data-id="{{ $key }}">
                                            <img src="{{ asset($procs->Image) }}" />
                                        </div>
                                    @endforeach
                                @else
                                    {{-- Fallback to Product Images --}}
                                    @foreach ($details->images as $key => $image)
                                        @php $keyid = $key + $keyidone + 1; @endphp
                                        <div class="indicator-item item" id="{{ $keyid }}" data-id="{{ $keyid }}">
                                            <img src="{{ asset($image->image) }}" />
                                        </div>
                                    @endforeach
                                @endif
                            
                                {{-- PostImage (Slider) --}}
                                @if (isset($details->PostImage))
                                    @foreach (json_decode($details->PostImage) as $key => $image)
                                        @php $keyid2 = $key + $keyidone3 + 1; @endphp
                                        <div class="indicator-item item" data-id="{{ $key + $keyid2 + 2 }}">
                                            <img src="{{ asset('public/images/product/slider/' . $image) }}" />
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="details_right">

                                        <div class="breadcrumb">
                                            <ul>
                                                <li><a href="{{ url('/') }}">Home</a></li>
                                                <li><span>/</span></li>
                                                <li><a
                                                        href="{{ url('/category/' . $details->category->slug) }}">{{ $details->category->name }}</a>
                                                </li>
                                                @if ($details->subcategory)
                                                    <li><span>/</span></li>
                                                    <li><a
                                                            href="#">{{ $details->subcategory ? $details->subcategory->subcategoryName : '' }}</a>
                                                    </li>
                                                @endif @if ($details->childcategory)
                                                    <li><span>/</span></li>
                                                    <li><a href="#">{{ $details->childcategory->childcategoryName }}</a>
                                                    </li>
                                                @endif
                                            </ul>
                                        </div>
                                        <div class="product">
                                            <div class="product-cart">
                                                <p class="name">{{ $details->name }}</p>
                                                <p class="details-price">
                                                    @if ($productsizes->count() > 0)
                                                        <del>৳<span id="delp">{{ $productsizes[0]->RegularPrice }}</span></del>
                                                        ৳<span id="regp">{{ $productsizes[0]->SalePrice }}</span>
                                                    @else
                                                        @if ($details->old_price)
                                                            <del>৳<span id="delp">{{ $details->old_price }}</span></del>
                                                        @endif ৳<span id="regp">{{ $details->new_price }}</span>
                                                    @endif

                                                </p>
                                                <div class="details-ratting-wrapper">
                                                    @php
                                                        $averageRating = $reviews->avg('ratting');
                                                        $filledStars = floor($averageRating);
                                                        $emptyStars = 5 - $filledStars;
                                                    @endphp

                                                    @if ($averageRating >= 0 && $averageRating <= 5)
                                                        @for ($i = 1; $i <= $filledStars; $i++)
                                                            <i class="fas fa-star"></i>
                                                        @endfor

                                                        @if ($averageRating == $filledStars)
                                                            {{-- If averageRating is an integer, don't display half star --}}
                                                        @else
                                                            <i class="far fa-star-half-alt"></i>
                                                        @endif

                                                        @for ($i = 1; $i <= $emptyStars; $i++)
                                                            <i class="far fa-star"></i>
                                                        @endfor

                                                        <span>{{ number_format($averageRating, 2) }}/5</span>
                                                    @else
                                                        <span>Invalid rating range</span>
                                                    @endif
                                                    <a class="all-reviews-button" href="#writeReview">See Reviews</a>
                                                </div>
                                                <div class="product-code">
                                                    <p><span>প্রোডাক্ট কোড : </span>{{ $details->product_code }}</p>
                                                </div>
                                                {{-- @if(isset($details->short_des))

                                                <div>
                                                    {!!$details->short_des!!}
                                                </div>
                                                @endif --}}

                                                <form action="{{ route('cart.store') }}" method="POST" id="addcart"
                                                    name="formName">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{ $details->id }}" />
                                                    @if ($productcolors->count() > 0)
                                                        <h6><b>Choose Color : &nbsp; &nbsp;</b></h6>
                                                        <div class="pro-color" style="width: 100%;">
                                                            
                                                            <div class="color_inner">
                                                                <div class="size-container">
                                                                    <div class="selector">
                                                                        @foreach ($productcolors as $key => $procolor)
                                                                            <div class="selector-item">
                                                                                <input type="radio"
                                                                                    id="fc-option{{ $procolor->id }}"
                                                                                    value="{{ $procolor->color }}"
                                                                                    name="product_color"
                                                                                    class="selector-item_radio emptyalert"
                                                                                    required />
                                                                                <label for="fc-option{{ $procolor->id }}"
                                                                                    id="smimg{{ $key }}" onclick="setimg({{$key}})"
                                                                                    style="" class="selector-item_label">
                                                                                    {{ $procolor->color }}
                                                                                </label>
                                                                            </div>
                                                                        @endforeach
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif

                                                    @php
                                                        $productsi = $productsizes;
                                                        $data = $productsi->where('size_id', 1)->first();
                                                    @endphp

                                                    @if(isset($data))

                                                        @foreach ($productsizes as $prosize)
                                                            <div class="selector-item" hidden>
                                                                <input type="radio" id="f-option{{ $prosize->id }}"
                                                                    value="{{ $prosize->size }}" name="product_size"
                                                                    class="selector-item_radio emptyalert" required checked />
                                                                <label for="f-option{{ $prosize->id }}"
                                                                    onclick="setprice({{$prosize->RegularPrice}},{{$prosize->SalePrice}})"
                                                                    class="selector-item_label">{{ $prosize->size }}</label>
                                                            </div>
                                                        @endforeach
                                                    @else

                                                        @if(count($productsizes) == 0)
                                                        @else
                                                            <h6 class="mb-2"><b>Size : &nbsp; &nbsp;</b></h6>
                                                            <div class="pro-size" style="width: 100%;">
                                                                <div class="size_inner">
                                                                    <div class="size-container">
                                                                        <div class="selector">
                                                                            @foreach ($productsizes as $prosize)
                                                                                <div class="selector-item">
                                                                                    <input type="radio" id="f-option{{ $prosize->id }}"
                                                                                        value="{{ $prosize->size }}" name="product_size"
                                                                                        class="selector-item_radio emptyalert"
                                                                                        required />
                                                                                    <label style="padding:0px 8px"
                                                                                        for="f-option{{ $prosize->id }}"
                                                                                        onclick="setprice({{$prosize->RegularPrice}},{{$prosize->SalePrice}})"
                                                                                        class="selector-item_label">{{ $prosize->size }}</label>
                                                                                </div>
                                                                            @endforeach
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endif
                                                        
                                                        @if(count($productsigments) == 0)
                                                        @else
                                                            <h6 class="mb-2"><b>সিলেক্ট করে কনফার্ম করুন :</b></h6>
                                                            <div class="pro-size d-flex" style="width: 100%;">
                                                                
                                                                <div class="size_inner">
                                                                    <div class="size-container">
                                                                        <div class="selector">
                                                                            @foreach ($productsigments as $productsigment)
                                                                                <div class="selector-item">
                                                                                    <input type="radio" id="sig-option{{ $productsigment->id }}"
                                                                                        value="{{ $productsigment->weight }}" name="product_sigment"
                                                                                        class="selector-item_radio emptyalert"
                                                                                         />
                                                                                    <label style="padding:0px 8px"
                                                                                        for="sig-option{{ $productsigment->id }}"
                                                                                        onclick="setpricesig('{{$productsigment->RegularPrice}}',{{$productsigment->SalePrice}})"
                                                                                        class="selector-item_label">{{ $productsigment->weight }}</label>
                                                                                </div>
                                                                            @endforeach
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endif
                                                    @endif

                                                    @if ($details->pro_unit)
                                                        <div class="pro_unig">
                                                            <label>Unit: {{ $details->pro_unit }}</label>
                                                            <input type="hidden" name="pro_unit"
                                                                value="{{ $details->pro_unit }}" />
                                                        </div>
                                                    @endif


                                                    <div class="row">
                                                        <div class="qty-cart col-sm-12">
                                                            <div class="quantity">
                                                                <span class="minus">-</span>
                                                                <input type="text" id="getqty" name="qty" value="1" />
                                                                <span class="plus">+</span>
                                                            </div>
                                                        </div>
                                                        <div class="d-flex single_product col-sm-12">
                                                            <input type="submit" class="btn px-4 add_cart_btn"
                                                                onclick="return sendSuccess();" name="add_cart"
                                                                value="🛒 কার্টে যোগ করুন "
                                                                style="background:#ed145b;border:1px solid #ed145b;" />

                                                            <input type="submit" id="order_now_btn_m"
                                                                class="btn px-4 order_now_btn order_now_btn_m"
                                                                onclick="return sendSuccess();" name="order_now"
                                                                value="🛒 অর্ডার করুন" />
                                                        </div>
                                                    </div>
                                                    <div class="mt-md-2 mt-2">
                                                        <h4 class="font-weight-bold">
                                                            <a class="btn btn-success w-100 call_now_btn"
                                                                href="tel: {{ $contact->hotline }}">
                                                                <i class="fa fa-phone-square"></i>
                                                                {{ $contact->hotline }}
                                                            </a>
                                                        </h4>
                                                    </div>

                                                    <div class="accordion mt-4">

                                                          <div class="accordion-item">
                                                            <div class="left">
                                                              <div class="icon-box">📄</div>
                                                              <div>
                                                                <h4>প্রোডাক্ট এর বিস্তারিত</h4>
                                                                <p>🔍 See our product description</p>
                                                              </div>
                                                            </div>
                                                            <div class="accordion-toggle"></div>
                                                          </div>
                                                          <div class="accordion-content">
                                                            <p>{!! $details->description !!}</p>
                                                          </div>
                                                        
                                                          <div class="accordion-item">
                                                            <div class="left">
                                                              <div class="icon-box">🎥</div>
                                                              <div>
                                                                <h4>প্রোডাক্ট এর ভিডিও</h4>
                                                                <p>🎬 See our product video</p>
                                                              </div>
                                                            </div>
                                                            <div class="accordion-toggle"></div>
                                                          </div>
                                                          <div class="accordion-content">
                                                             <iframe width="100%" 
                                                                  src="https://www.youtube.com/embed/{{$details->pro_video}}" 
                                                                  title="YouTube video player" 
                                                                  frameborder="0" 
                                                                  allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                                                                  allowfullscreen
                                                                  style="width:100%; height:350px;">
                                                                </iframe>
                                                          </div>
                                                        
                                                          <div class="accordion-item">
                                                            <div class="left">
                                                              <div class="icon-box">❓</div>
                                                              <div>
                                                                <!--<h4>Why choose <span style="text-transform:uppercase">{{env('APP_NAME')}}</span></h4>-->
                                                                <h4>কেন আমাদের প্রোডাক্ট নিবেন</h4>
                                                                <p>🛍 The Ultimate Shopping Destination!</p>
                                                              </div>
                                                            </div>
                                                            <div class="accordion-toggle"></div>
                                                          </div>
                                                          <div class="accordion-content">
                                                             <p>{!! App\Models\GeneralSetting::first()->why_choose_us !!}</p>
                                                          </div>
                                                        
                                                          <div class="accordion-item">
                                                            <div class="left">
                                                              <div class="icon-box">🔄</div>
                                                              <div>
                                                                <h4>পন্য ফেরতের শর্ত</h4>
                                                                <p>🚚 Delivery & Return Policy</p>
                                                              </div>
                                                            </div>
                                                            <div class="accordion-toggle"></div>
                                                          </div>
                                                          <div class="accordion-content">
                                                            <p>{!! App\Models\GeneralSetting::first()->return_policy !!}</p>
                                                          </div>
                                                        
                                                        </div>
                                                </form>


                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>

 

    <section class="related-product-section">
        <div class="container">
            <div class="row">
                <div class="related-title">
                    <h5>Related Product</h5>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <div class="product_sliders" style="padding: 0px;">
                        @foreach ($products as $key => $value)
                           <div class="product_item wist_item"  style="padding: 0px;">
                            <div class="product_item_inner">
                                @if($value->old_price)
                                <div class="sale-badge">
                                    <div class="sale-badge-inner">
                                        <div class="sale-badge-box">
                                            <span class="sale-badge-text">
                                                <p>@php $discount=(((($value->old_price)-($value->new_price))*100) / ($value->old_price)) @endphp {{ number_format($discount, 0) }}%  ছাড়</p> 
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                @endif
                                <div class="pro_img">
                                    <a href="{{ route('product', $value->slug) }}">
                                        <img src="{{ asset($value->image ? $value->image->image : '') }}"
                                            alt="{{ $value->name }}"  style="border-radius:4px 4px 0px 0px" />
                                    </a>
                                </div>
                                <div class="pro_des">
                                    <div class="pro_name">
                                        <a
                                            href="{{ route('product', $value->slug) }}">{{ Str::limit($value->name, 80) }}</a>
                                    </div>
                                     <div class="stars d-flex justify-content-center pb-2">
                                        <div class="d-flex align-items-center text-warning">
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i> 
                                        </div>
                                    </div>
                                    <div class="pro_price">
                                        <p>
                                            @if ($value->old_price)
                                             <del>৳ {{ $value->old_price }}</del>
                                            @endif

                                            ৳ {{ $value->new_price }} 
                                           
                                        </p>
                                    </div>
                                </div>
                            </div>

                            @if (!$value->prosizes->isEmpty() || !$value->procolors->isEmpty())
                                <div class="pro_btn">
                                   
                                    <div class="cart_btn order_button">
                                        <a href="{{ route('product', $value->slug) }}"
                                            class="addcartbutton"><i class="fa-solid fa-cart-shopping"></i> &nbsp;অর্ডার করুন </a>
                                    </div>
                                </div>
                            @else
                                <div class="pro_btn">
                                    
                                    <form action="{{ route('cart.store') }}" method="POST">
                                        @csrf
                                        <input type="hidden" name="id" value="{{ $value->id }}" />
                                        <input type="hidden" name="qty" value="1" />
                                        <button type="submit"><i class="fa-solid fa-cart-shopping"></i> &nbsp;অর্ডার করুন</button>
                                    </form>
                                </div>
                            @endif
                        </div>
                        @endforeach
                    </div>
                </div>
             </div>
        </div>
    </section>

@endsection @push('script')
    <script src="{{ asset('public/frontEnd/js/owl.carousel.min.js') }}"></script>

    <script src="{{ asset('public/frontEnd/js/zoomsl.min.js') }}"></script>
    
    <script>
      const items = document.querySelectorAll(".accordion-item");
    
      items.forEach((item, index) => {
        item.addEventListener("click", () => {
          item.classList.toggle("active");
    
          const content = item.nextElementSibling;
          if (item.classList.contains("active")) {
            content.style.display = "block";
          } else {
            content.style.display = "none";
          }
        });
      });
    </script>

    <script>

        function setprice(delp, regp) {
            $('#delp').html(delp);
            $('#regp').html(regp);
        }
        function setpricesig(delp, regp) {
            $('#delp').html(delp);
            $('#regp').html(regp);
        }
        $(document).ready(function () {
            $(".details_slider").owlCarousel({
                margin: 15,
                items: 1,
                loop: true,
                dots: false,
                autoplay: true,
                autoplayTimeout: 1000000000,
                autoplayHoverPause: true,
            });
            $(".indicator-item").on("click", function () {
                var slideIndex = $(this).data("id");
                $(".details_slider").trigger("to.owl.carousel", slideIndex);
            });

        });

        function setimg(indx) {
            // $(".selector-item_label").css("border", '1px solid #ddd');
            // $("#smimg" + indx).css("border", '2px solid red');
            $(".details_slider").trigger("to.owl.carousel", indx);
        }
    </script>
     
    <!--Data Layer Start--> 
    <script type="text/javascript">
        window.dataLayer = window.dataLayer || [];
        dataLayer.push({
            ecommerce: null
        });
        dataLayer.push({
            event: "view_item",
            ecommerce: {
                currency: "BDT",
                value: Number("<?php echo $details->new_price?>"),
                items: [{
                    item_name: "{{ $details->name }}",
                    item_id: "<?php echo $details->id ?>",
                    price: Number("<?php echo $details->new_price?>"),
                    item_brand: "{{ $details->brand?$details->brand->name:'' }}",
                    item_category: "{{ $details->category->name }}",
                    item_variant: Number("<?php echo $details->pro_unit ?>"),
                    currency: "BDT",
                    quantity: $('#getqty').val()
                }]
    
            }
        });
    </script>
    <script type="text/javascript">
        $(document).ready(function() {
            document.getElementById('addcart').addEventListener('submit', function(event) {
                window.dataLayer = window.dataLayer || [];
                dataLayer.push({
                    ecommerce: null
                });
                dataLayer.push({
                    event: "add_to_cart",
                    ecommerce: {
                        currency: "BDT",
                        value: Number("<?php echo $details->new_price?>"),
                        items: [{
                            item_name: "{{ $details->name }}",
                            item_id: "<?php echo $details->id ?>",
                            price: Number("<?php echo $details->new_price?>"),
                            item_brand: "{{ $details->brand?$details->brand->name:'' }}",
                            item_category: "{{ $details->category->name }}",
                            item_variant: Number("<?php echo $details->pro_unit ?>"),
                            currency: "BDT",
                            quantity: $('#getqty').val()
                        }]
                    }
                });
            });
        });
    </script>
    
    <script>
        $(document).ready(function () {
            $(".related_slider").owlCarousel({
                margin: 10,
                items: 6,
                loop: true,
                dots: true,
                nav: true,
                autoplay: true,
                autoplayTimeout: 6000,
                autoplayHoverPause: true,
                responsiveClass: true,
                responsive: {
                    0: {
                        items: 2,
                        nav: true,
                    },
                    600: {
                        items: 3,
                        nav: false,
                    },
                    1000: {
                        items: 6,
                        nav: true,
                        loop: true,
                    },
                },
            });
            // $('.owl-nav').remove();
        });
    </script>
    <script>
        $(document).ready(function () {
            $(".minus").click(function () {
                var $input = $(this).parent().find("input");
                var count = parseInt($input.val()) - 1;
                count = count < 1 ? 1 : count;
                $input.val(count);
                $input.change();
                return false;
            });
            $(".plus").click(function () {
                var $input = $(this).parent().find("input");
                $input.val(parseInt($input.val()) + 1);
                $input.change();
                return false;
            });
        });
    </script>

    <script>
        function sendSuccess() {
            // size validation
            size = document.forms["formName"]["product_size"].value;
            if (size != "") {
                // access
            } else {
                toastr.warning("Please select any size");
                return false;
            }
            color = document.forms["formName"]["product_color"].value;
            if (color != "") {
                // access
            } else {
                toastr.error("Please select any color");
                return false;
            }
        }
    </script>
    <script>
        $(document).ready(function () {
            $(".rating label").click(function () {
                $(".rating label").removeClass("active");
                $(this).addClass("active");
            });
        });
    </script>
   <script>
        $(document).ready(function () {
            $(".thumb_slider").owlCarousel({
                margin: 15,
                items: 4,
                loop: true,
                dots: false,
                nav: true,
                autoplay: true, 
                autoplayTimeout: 3000, 
                autoplayHoverPause: true, 
            });
        });
    </script>


    <script type="text/javascript">
        $(".block__pic").imagezoomsl({
            zoomrange: [3, 3]
        });
    </script>
@endpush
