<?php $__env->startSection('title', $details->name); ?>
<?php $__env->startPush('seo'); ?>
    <meta name="app-url" content="<?php echo e(route('product', $details->slug)); ?>" />
    <meta name="robots" content="index, follow" />
    <meta name="description" content="<?php echo e($details->meta_description); ?>" />
    <meta name="keywords" content="<?php echo e($details->slug); ?>" />

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="product" />
    <meta name="twitter:site" content="<?php echo e($details->name); ?>" />
    <meta name="twitter:title" content="<?php echo e($details->name); ?>" />
    <meta name="twitter:description" content="<?php echo e($details->meta_description); ?>" />
    <meta name="twitter:creator" content="gomobd.com" />
    <meta property="og:url" content="<?php echo e(route('product', $details->slug)); ?>" />
    <meta name="twitter:image" content="<?php echo e(asset($details->image->image)); ?>" />

    <!-- Open Graph data -->
    <meta property="og:title" content="<?php echo e($details->name); ?>" />
    <meta property="og:type" content="product" />
    <meta property="og:url" content="<?php echo e(route('product', $details->slug)); ?>" />
    <meta property="og:image" content="<?php echo e(asset($details->image->image)); ?>" />
    <meta property="og:description" content="<?php echo e($details->meta_description); ?>" />
    <meta property="og:site_name" content="<?php echo e($details->name); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/css/zoomsl.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<style>
    
    .accordion {
      width: 100%;
      border-top: 1px solid #ccc;
    }

    .accordion-item {
        border:none;
      border-bottom: 1px solid #ccc;
      padding: 15px 10px;
      display: flex;
      align-items: center;
      justify-content: space-between;
      cursor: pointer;
    }

    .accordion-item .left {
      display: flex;
      align-items: center;
      gap: 12px;
    }

    .accordion-item .icon-box {
      background: #d5fbe0;
      padding: 10px;
      border-radius: 8px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 20px;
    }

    .accordion-item h4 {
      margin: 0;
      font-size: 18px;
      font-weight: bold;
    }

    .accordion-item p {
      margin: 0;
      font-size: 14px;
      color: #555;
    }

    .accordion-toggle {
      font-size: 20px;
      font-weight: bold;
      transition: transform 0.2s;
    }

    .accordion-content {
      display: none;
      padding: 10px 45px;
      font-size: 14px;
      color: #333;
      background: #fafafa;
    }

    .accordion-item.active .accordion-toggle::after {
      content: "–";
    }

    .accordion-item:not(.active) .accordion-toggle::after {
      content: "+";
    }
    
    .color_inner {
        display: flex;
        margin-top: -5px;
    }
    .size_inner {
        display: flex;
        margin-top: -4px;
    }
    
    .selector {
        display: flex;
        flex-wrap: wrap; /* জায়গা শেষ হলে নিচে যাবে */
        gap: 10px; /* আইটেমের মধ্যে ফাঁক */
    }
    
    .selector-item {
        display: flex;
        align-items: center;
    } 
</style>
    <div class="homeproduct main-details-page prdetail">
        <div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <section class="product-section">
                        <div class="container">
                            <div class="row">
                                <div class="col-sm-6 position-relative">
                                    <?php if($details->old_price): ?>
                                        <div class="product-details-discount-badge">
                                            <div class="sale-badge">
                                                <div class="sale-badge-inner">
                                                    <div class="sale-badge-box">
                                                        <span class="sale-badge-text">
                                                            <p> <?php $discount = (((($details->old_price) - ($details->new_price)) * 100) / ($details->old_price)) ?>
                                                                <?php echo e(number_format($discount, 0)); ?>% ছাড়
                                                            </p>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <div class="details_slider owl-carousel">
                                        <?php if($productcolors->count() > 0): ?>
                                            <?php $__currentLoopData = $productcolors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="dimage_item">
                                                    <img src="<?php echo e(asset($proc->Image)); ?>" class="block__pic" />
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <?php $__currentLoopData = $details->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="dimage_item">
                                                    <img src="<?php echo e(asset($value->image)); ?>" class="block__pic" />
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                        <?php if(isset($details->PostImage)): ?>
                                            <?php $__currentLoopData = json_decode($details->PostImage); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="dimage_item">
                                                    <img src="<?php echo e(asset('public/images/product/slider')); ?>/<?php echo e($image); ?>"
                                                        class="block__pic" />
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                    <?php
                                $keyidone = 0;
                                $keyidone3 = 0;
                                $keyid = 0;
                            
                                // Total image count calculation
                                $totalImages = 0;
                                if ($productcolors->count() > 0) {
                                    $totalImages += $productcolors->count();
                                } else {
                                    $totalImages += $details->images->count();
                                }
                                if (isset($details->PostImage)) {
                                    $totalImages += count(json_decode($details->PostImage));
                                }
                            
                                $carouselClass = $totalImages > 4 ? 'thumb_slider owl-carousel' : '';
                            ?>
                            
                            <div class="indicator_thumb <?php echo e($carouselClass); ?>">
                                
                                <?php if($productcolors->count() > 0): ?>
                                    <?php $__currentLoopData = $productcolors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $procs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="indicator-item item" id="<?php echo e(++$keyidone); ?>" data-id="<?php echo e($key); ?>">
                                            <img src="<?php echo e(asset($procs->Image)); ?>" />
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    
                                    <?php $__currentLoopData = $details->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $keyid = $key + $keyidone + 1; ?>
                                        <div class="indicator-item item" id="<?php echo e($keyid); ?>" data-id="<?php echo e($keyid); ?>">
                                            <img src="<?php echo e(asset($image->image)); ?>" />
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            
                                
                                <?php if(isset($details->PostImage)): ?>
                                    <?php $__currentLoopData = json_decode($details->PostImage); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $keyid2 = $key + $keyidone3 + 1; ?>
                                        <div class="indicator-item item" data-id="<?php echo e($key + $keyid2 + 2); ?>">
                                            <img src="<?php echo e(asset('public/images/product/slider/' . $image)); ?>" />
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="details_right">

                                        <div class="breadcrumb">
                                            <ul>
                                                <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
                                                <li><span>/</span></li>
                                                <li><a
                                                        href="<?php echo e(url('/category/' . $details->category->slug)); ?>"><?php echo e($details->category->name); ?></a>
                                                </li>
                                                <?php if($details->subcategory): ?>
                                                    <li><span>/</span></li>
                                                    <li><a
                                                            href="#"><?php echo e($details->subcategory ? $details->subcategory->subcategoryName : ''); ?></a>
                                                    </li>
                                                <?php endif; ?> <?php if($details->childcategory): ?>
                                                    <li><span>/</span></li>
                                                    <li><a href="#"><?php echo e($details->childcategory->childcategoryName); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                        <div class="product">
                                            <div class="product-cart">
                                                <p class="name"><?php echo e($details->name); ?></p>
                                                <p class="details-price">
                                                    <?php if($productsizes->count() > 0): ?>
                                                        <del>৳<span id="delp"><?php echo e($productsizes[0]->RegularPrice); ?></span></del>
                                                        ৳<span id="regp"><?php echo e($productsizes[0]->SalePrice); ?></span>
                                                    <?php else: ?>
                                                        <?php if($details->old_price): ?>
                                                            <del>৳<span id="delp"><?php echo e($details->old_price); ?></span></del>
                                                        <?php endif; ?> ৳<span id="regp"><?php echo e($details->new_price); ?></span>
                                                    <?php endif; ?>

                                                </p>
                                                <div class="details-ratting-wrapper">
                                                    <?php
                                                        $averageRating = $reviews->avg('ratting');
                                                        $filledStars = floor($averageRating);
                                                        $emptyStars = 5 - $filledStars;
                                                    ?>

                                                    <?php if($averageRating >= 0 && $averageRating <= 5): ?>
                                                        <?php for($i = 1; $i <= $filledStars; $i++): ?>
                                                            <i class="fas fa-star"></i>
                                                        <?php endfor; ?>

                                                        <?php if($averageRating == $filledStars): ?>
                                                            
                                                        <?php else: ?>
                                                            <i class="far fa-star-half-alt"></i>
                                                        <?php endif; ?>

                                                        <?php for($i = 1; $i <= $emptyStars; $i++): ?>
                                                            <i class="far fa-star"></i>
                                                        <?php endfor; ?>

                                                        <span><?php echo e(number_format($averageRating, 2)); ?>/5</span>
                                                    <?php else: ?>
                                                        <span>Invalid rating range</span>
                                                    <?php endif; ?>
                                                    <a class="all-reviews-button" href="#writeReview">See Reviews</a>
                                                </div>
                                                <div class="product-code">
                                                    <p><span>প্রোডাক্ট কোড : </span><?php echo e($details->product_code); ?></p>
                                                </div>
                                                

                                                <form action="<?php echo e(route('cart.store')); ?>" method="POST" id="addcart"
                                                    name="formName">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="id" value="<?php echo e($details->id); ?>" />
                                                    <?php if($productcolors->count() > 0): ?>
                                                        <h6><b>Choose Color : &nbsp; &nbsp;</b></h6>
                                                        <div class="pro-color" style="width: 100%;">
                                                            
                                                            <div class="color_inner">
                                                                <div class="size-container">
                                                                    <div class="selector">
                                                                        <?php $__currentLoopData = $productcolors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $procolor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="selector-item">
                                                                                <input type="radio"
                                                                                    id="fc-option<?php echo e($procolor->id); ?>"
                                                                                    value="<?php echo e($procolor->color); ?>"
                                                                                    name="product_color"
                                                                                    class="selector-item_radio emptyalert"
                                                                                    required />
                                                                                <label for="fc-option<?php echo e($procolor->id); ?>"
                                                                                    id="smimg<?php echo e($key); ?>" onclick="setimg(<?php echo e($key); ?>)"
                                                                                    style="" class="selector-item_label">
                                                                                    <?php echo e($procolor->color); ?>

                                                                                </label>
                                                                            </div>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>

                                                    <?php
                                                        $productsi = $productsizes;
                                                        $data = $productsi->where('size_id', 1)->first();
                                                    ?>

                                                    <?php if(isset($data)): ?>

                                                        <?php $__currentLoopData = $productsizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prosize): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="selector-item" hidden>
                                                                <input type="radio" id="f-option<?php echo e($prosize->id); ?>"
                                                                    value="<?php echo e($prosize->size); ?>" name="product_size"
                                                                    class="selector-item_radio emptyalert" required checked />
                                                                <label for="f-option<?php echo e($prosize->id); ?>"
                                                                    onclick="setprice(<?php echo e($prosize->RegularPrice); ?>,<?php echo e($prosize->SalePrice); ?>)"
                                                                    class="selector-item_label"><?php echo e($prosize->size); ?></label>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php else: ?>

                                                        <?php if(count($productsizes) == 0): ?>
                                                        <?php else: ?>
                                                            <h6 class="mb-2"><b>Size : &nbsp; &nbsp;</b></h6>
                                                            <div class="pro-size" style="width: 100%;">
                                                                <div class="size_inner">
                                                                    <div class="size-container">
                                                                        <div class="selector">
                                                                            <?php $__currentLoopData = $productsizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prosize): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <div class="selector-item">
                                                                                    <input type="radio" id="f-option<?php echo e($prosize->id); ?>"
                                                                                        value="<?php echo e($prosize->size); ?>" name="product_size"
                                                                                        class="selector-item_radio emptyalert"
                                                                                        required />
                                                                                    <label style="padding:0px 8px"
                                                                                        for="f-option<?php echo e($prosize->id); ?>"
                                                                                        onclick="setprice(<?php echo e($prosize->RegularPrice); ?>,<?php echo e($prosize->SalePrice); ?>)"
                                                                                        class="selector-item_label"><?php echo e($prosize->size); ?></label>
                                                                                </div>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                        
                                                        <?php if(count($productsigments) == 0): ?>
                                                        <?php else: ?>
                                                            <h6 class="mb-2"><b>সিলেক্ট করে কনফার্ম করুন :</b></h6>
                                                            <div class="pro-size d-flex" style="width: 100%;">
                                                                
                                                                <div class="size_inner">
                                                                    <div class="size-container">
                                                                        <div class="selector">
                                                                            <?php $__currentLoopData = $productsigments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productsigment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <div class="selector-item">
                                                                                    <input type="radio" id="sig-option<?php echo e($productsigment->id); ?>"
                                                                                        value="<?php echo e($productsigment->weight); ?>" name="product_sigment"
                                                                                        class="selector-item_radio emptyalert"
                                                                                         />
                                                                                    <label style="padding:0px 8px"
                                                                                        for="sig-option<?php echo e($productsigment->id); ?>"
                                                                                        onclick="setpricesig('<?php echo e($productsigment->RegularPrice); ?>',<?php echo e($productsigment->SalePrice); ?>)"
                                                                                        class="selector-item_label"><?php echo e($productsigment->weight); ?></label>
                                                                                </div>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php endif; ?>

                                                    <?php if($details->pro_unit): ?>
                                                        <div class="pro_unig">
                                                            <label>Unit: <?php echo e($details->pro_unit); ?></label>
                                                            <input type="hidden" name="pro_unit"
                                                                value="<?php echo e($details->pro_unit); ?>" />
                                                        </div>
                                                    <?php endif; ?>


                                                    <div class="row">
                                                        <div class="qty-cart col-sm-12">
                                                            <div class="quantity">
                                                                <span class="minus">-</span>
                                                                <input type="text" id="getqty" name="qty" value="1" />
                                                                <span class="plus">+</span>
                                                            </div>
                                                        </div>
                                                        <div class="d-flex single_product col-sm-12">
                                                            <input type="submit" class="btn px-4 add_cart_btn"
                                                                onclick="return sendSuccess();" name="add_cart"
                                                                value="🛒 কার্টে যোগ করুন "
                                                                style="background:#ed145b;border:1px solid #ed145b;" />

                                                            <input type="submit" id="order_now_btn_m"
                                                                class="btn px-4 order_now_btn order_now_btn_m"
                                                                onclick="return sendSuccess();" name="order_now"
                                                                value="🛒 অর্ডার করুন" />
                                                        </div>
                                                    </div>
                                                    <div class="mt-md-2 mt-2">
                                                        <h4 class="font-weight-bold">
                                                            <a class="btn btn-success w-100 call_now_btn"
                                                                href="tel: <?php echo e($contact->hotline); ?>">
                                                                <i class="fa fa-phone-square"></i>
                                                                <?php echo e($contact->hotline); ?>

                                                            </a>
                                                        </h4>
                                                    </div>

                                                    <div class="accordion mt-4">

                                                          <div class="accordion-item">
                                                            <div class="left">
                                                              <div class="icon-box">📄</div>
                                                              <div>
                                                                <h4>প্রোডাক্ট এর বিস্তারিত</h4>
                                                                <p>🔍 See our product description</p>
                                                              </div>
                                                            </div>
                                                            <div class="accordion-toggle"></div>
                                                          </div>
                                                          <div class="accordion-content">
                                                            <p><?php echo $details->description; ?></p>
                                                          </div>
                                                        
                                                          <div class="accordion-item">
                                                            <div class="left">
                                                              <div class="icon-box">🎥</div>
                                                              <div>
                                                                <h4>প্রোডাক্ট এর ভিডিও</h4>
                                                                <p>🎬 See our product video</p>
                                                              </div>
                                                            </div>
                                                            <div class="accordion-toggle"></div>
                                                          </div>
                                                          <div class="accordion-content">
                                                             <iframe width="100%" 
                                                                  src="https://www.youtube.com/embed/<?php echo e($details->pro_video); ?>" 
                                                                  title="YouTube video player" 
                                                                  frameborder="0" 
                                                                  allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" 
                                                                  allowfullscreen
                                                                  style="width:100%; height:350px;">
                                                                </iframe>
                                                          </div>
                                                        
                                                          <div class="accordion-item">
                                                            <div class="left">
                                                              <div class="icon-box">❓</div>
                                                              <div>
                                                                <!--<h4>Why choose <span style="text-transform:uppercase"><?php echo e(env('APP_NAME')); ?></span></h4>-->
                                                                <h4>কেন আমাদের প্রোডাক্ট নিবেন</h4>
                                                                <p>🛍 The Ultimate Shopping Destination!</p>
                                                              </div>
                                                            </div>
                                                            <div class="accordion-toggle"></div>
                                                          </div>
                                                          <div class="accordion-content">
                                                             <p><?php echo App\Models\GeneralSetting::first()->why_choose_us; ?></p>
                                                          </div>
                                                        
                                                          <div class="accordion-item">
                                                            <div class="left">
                                                              <div class="icon-box">🔄</div>
                                                              <div>
                                                                <h4>পন্য ফেরতের শর্ত</h4>
                                                                <p>🚚 Delivery & Return Policy</p>
                                                              </div>
                                                            </div>
                                                            <div class="accordion-toggle"></div>
                                                          </div>
                                                          <div class="accordion-content">
                                                            <p><?php echo App\Models\GeneralSetting::first()->return_policy; ?></p>
                                                          </div>
                                                        
                                                        </div>
                                                </form>


                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </div>

 

    <section class="related-product-section">
        <div class="container">
            <div class="row">
                <div class="related-title">
                    <h5>Related Product</h5>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <div class="product_sliders" style="padding: 0px;">
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <div class="product_item wist_item"  style="padding: 0px;">
                            <div class="product_item_inner">
                                <?php if($value->old_price): ?>
                                <div class="sale-badge">
                                    <div class="sale-badge-inner">
                                        <div class="sale-badge-box">
                                            <span class="sale-badge-text">
                                                <p><?php $discount=(((($value->old_price)-($value->new_price))*100) / ($value->old_price)) ?> <?php echo e(number_format($discount, 0)); ?>%  ছাড়</p> 
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <div class="pro_img">
                                    <a href="<?php echo e(route('product', $value->slug)); ?>">
                                        <img src="<?php echo e(asset($value->image ? $value->image->image : '')); ?>"
                                            alt="<?php echo e($value->name); ?>"  style="border-radius:4px 4px 0px 0px" />
                                    </a>
                                </div>
                                <div class="pro_des">
                                    <div class="pro_name">
                                        <a
                                            href="<?php echo e(route('product', $value->slug)); ?>"><?php echo e(Str::limit($value->name, 80)); ?></a>
                                    </div>
                                     <div class="stars d-flex justify-content-center pb-2">
                                        <div class="d-flex align-items-center text-warning">
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i> 
                                        </div>
                                    </div>
                                    <div class="pro_price">
                                        <p>
                                            <?php if($value->old_price): ?>
                                             <del>৳ <?php echo e($value->old_price); ?></del>
                                            <?php endif; ?>

                                            ৳ <?php echo e($value->new_price); ?> 
                                           
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <?php if(!$value->prosizes->isEmpty() || !$value->procolors->isEmpty()): ?>
                                <div class="pro_btn">
                                   
                                    <div class="cart_btn order_button">
                                        <a href="<?php echo e(route('product', $value->slug)); ?>"
                                            class="addcartbutton"><i class="fa-solid fa-cart-shopping"></i> &nbsp;অর্ডার করুন </a>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="pro_btn">
                                    
                                    <form action="<?php echo e(route('cart.store')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="id" value="<?php echo e($value->id); ?>" />
                                        <input type="hidden" name="qty" value="1" />
                                        <button type="submit"><i class="fa-solid fa-cart-shopping"></i> &nbsp;অর্ডার করুন</button>
                                    </form>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
             </div>
        </div>
    </section>

<?php $__env->stopSection(); ?> <?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('public/frontEnd/js/owl.carousel.min.js')); ?>"></script>

    <script src="<?php echo e(asset('public/frontEnd/js/zoomsl.min.js')); ?>"></script>
    
    <script>
      const items = document.querySelectorAll(".accordion-item");
    
      items.forEach((item, index) => {
        item.addEventListener("click", () => {
          item.classList.toggle("active");
    
          const content = item.nextElementSibling;
          if (item.classList.contains("active")) {
            content.style.display = "block";
          } else {
            content.style.display = "none";
          }
        });
      });
    </script>

    <script>

        function setprice(delp, regp) {
            $('#delp').html(delp);
            $('#regp').html(regp);
        }
        function setpricesig(delp, regp) {
            $('#delp').html(delp);
            $('#regp').html(regp);
        }
        $(document).ready(function () {
            $(".details_slider").owlCarousel({
                margin: 15,
                items: 1,
                loop: true,
                dots: false,
                autoplay: true,
                autoplayTimeout: 1000000000,
                autoplayHoverPause: true,
            });
            $(".indicator-item").on("click", function () {
                var slideIndex = $(this).data("id");
                $(".details_slider").trigger("to.owl.carousel", slideIndex);
            });

        });

        function setimg(indx) {
            // $(".selector-item_label").css("border", '1px solid #ddd');
            // $("#smimg" + indx).css("border", '2px solid red');
            $(".details_slider").trigger("to.owl.carousel", indx);
        }
    </script>
     
    <!--Data Layer Start--> 
    <script type="text/javascript">
        window.dataLayer = window.dataLayer || [];
        dataLayer.push({
            ecommerce: null
        });
        dataLayer.push({
            event: "view_item",
            ecommerce: {
                currency: "BDT",
                value: Number("<?php echo $details->new_price?>"),
                items: [{
                    item_name: "<?php echo e($details->name); ?>",
                    item_id: "<?php echo $details->id ?>",
                    price: Number("<?php echo $details->new_price?>"),
                    item_brand: "<?php echo e($details->brand?$details->brand->name:''); ?>",
                    item_category: "<?php echo e($details->category->name); ?>",
                    item_variant: Number("<?php echo $details->pro_unit ?>"),
                    currency: "BDT",
                    quantity: $('#getqty').val()
                }]
    
            }
        });
    </script>
    <script type="text/javascript">
        $(document).ready(function() {
            document.getElementById('addcart').addEventListener('submit', function(event) {
                window.dataLayer = window.dataLayer || [];
                dataLayer.push({
                    ecommerce: null
                });
                dataLayer.push({
                    event: "add_to_cart",
                    ecommerce: {
                        currency: "BDT",
                        value: Number("<?php echo $details->new_price?>"),
                        items: [{
                            item_name: "<?php echo e($details->name); ?>",
                            item_id: "<?php echo $details->id ?>",
                            price: Number("<?php echo $details->new_price?>"),
                            item_brand: "<?php echo e($details->brand?$details->brand->name:''); ?>",
                            item_category: "<?php echo e($details->category->name); ?>",
                            item_variant: Number("<?php echo $details->pro_unit ?>"),
                            currency: "BDT",
                            quantity: $('#getqty').val()
                        }]
                    }
                });
            });
        });
    </script>
    
    <script>
        $(document).ready(function () {
            $(".related_slider").owlCarousel({
                margin: 10,
                items: 6,
                loop: true,
                dots: true,
                nav: true,
                autoplay: true,
                autoplayTimeout: 6000,
                autoplayHoverPause: true,
                responsiveClass: true,
                responsive: {
                    0: {
                        items: 2,
                        nav: true,
                    },
                    600: {
                        items: 3,
                        nav: false,
                    },
                    1000: {
                        items: 6,
                        nav: true,
                        loop: true,
                    },
                },
            });
            // $('.owl-nav').remove();
        });
    </script>
    <script>
        $(document).ready(function () {
            $(".minus").click(function () {
                var $input = $(this).parent().find("input");
                var count = parseInt($input.val()) - 1;
                count = count < 1 ? 1 : count;
                $input.val(count);
                $input.change();
                return false;
            });
            $(".plus").click(function () {
                var $input = $(this).parent().find("input");
                $input.val(parseInt($input.val()) + 1);
                $input.change();
                return false;
            });
        });
    </script>

    <script>
        function sendSuccess() {
            // size validation
            size = document.forms["formName"]["product_size"].value;
            if (size != "") {
                // access
            } else {
                toastr.warning("Please select any size");
                return false;
            }
            color = document.forms["formName"]["product_color"].value;
            if (color != "") {
                // access
            } else {
                toastr.error("Please select any color");
                return false;
            }
        }
    </script>
    <script>
        $(document).ready(function () {
            $(".rating label").click(function () {
                $(".rating label").removeClass("active");
                $(this).addClass("active");
            });
        });
    </script>
   <script>
        $(document).ready(function () {
            $(".thumb_slider").owlCarousel({
                margin: 15,
                items: 4,
                loop: true,
                dots: false,
                nav: true,
                autoplay: true, 
                autoplayTimeout: 3000, 
                autoplayHoverPause: true, 
            });
        });
    </script>


    <script type="text/javascript">
        $(".block__pic").imagezoomsl({
            zoomrange: [3, 3]
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontEnd.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rojaluxeshop/public_html/resources/views/frontEnd/layouts/pages/details.blade.php ENDPATH**/ ?>