<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width" />
    <title><?php echo e($generalsetting->name); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset($generalsetting->favicon)); ?>" type="image/x-icon" />
    <!-- fot awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css')); ?>/all.css" />
    <!-- core css -->
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css')); ?>/bootstrap.min.css" />

    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css')); ?>/animate.css" />
    <!-- owl carousel -->
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css')); ?>/owl.theme.default.css" />
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css')); ?>/owl.carousel.min.css" />
    <!-- owl carousel -->
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css')); ?>/select2.min.css" />
    <!-- common css -->
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css')); ?>/style.css" />
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css')); ?>/responsive.css" />
    <link rel="stylesheet" href="<?php echo e(asset('public/frontEnd/campaign/css')); ?>/landing.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">
    <style>
        * {
            font-family: "Roboto", sans-serif;
        }
        
        .size_inner {
            display: flex;
            margin-top: -4px;
        }
        .size-container {
    margin-bottom: 12px;
}

.selector {
    position: relative;
    width: 100%;
    background-color: inherit;
    display: flex;
    align-items: center;
    justify-content: flex-start;
    column-gap: 10px;
}
.selector-item {
    position: relative;
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
}
.selector-item_radio {
    appearance: none;
    display: none;
}
.selector-item label {
    border: 1px solid #7d7d7d;
}
.selector-item_label {
    position: relative;
    height: 100%;
    width: 100%;
    text-align: center;
    border-radius: 0;
    line-height: 30px;
    font-weight: 600;
    transition-duration: 0.5s;
    transition-property: transform, color, box-shadow;
    transform: none;
    margin: 0;
    padding: 0px 8px;
    color: #000;
}
    </style>



    <meta name="app-url" content="<?php echo e(route('campaign', $campaign_data->slug)); ?>" />
    <meta name="robots" content="index, follow" />
    <meta name="description" content="<?php echo e($campaign_data->description); ?>" />
    <meta name="keywords" content="<?php echo e($campaign_data->slug); ?>" />

    <!-- Twitter Card data -->
    <meta name="twitter:card" content="product" />
    <meta name="twitter:site" content="<?php echo e($campaign_data->name); ?>" />
    <meta name="twitter:title" content="<?php echo e($campaign_data->name); ?>" />
    <meta name="twitter:description" content="<?php echo e($campaign_data->description); ?>" />
    <meta name="twitter:creator" content="hellodinajpur.com" />
    <meta property="og:url" content="<?php echo e(route('campaign', $campaign_data->slug)); ?>" />
    <meta name="twitter:image" content="<?php echo e(asset($campaign_data->image_one)); ?>" />

    <!-- Open Graph data -->
    <meta property="og:title" content="<?php echo e($campaign_data->name); ?>" />
    <meta property="og:type" content="product" />
    <meta property="og:url" content="<?php echo e(route('campaign', $campaign_data->slug)); ?>" />
    <meta property="og:image" content="<?php echo e(asset($campaign_data->image_one)); ?>" />
    <meta property="og:description" content="<?php echo e($campaign_data->description); ?>" />
    <meta property="og:site_name" content="<?php echo e($campaign_data->name); ?>" />

     <?php $__currentLoopData = $pixels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pixel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- Facebook Pixel Code -->
        <script>
            !(function (f, b, e, v, n, t, s) {
                if (f.fbq) return;
                n = f.fbq = function () {
                    n.callMethod ? n.callMethod.apply(n, arguments) : n.queue.push(arguments);
                };
                if (!f._fbq) f._fbq = n;
                n.push = n;
                n.loaded = !0;
                n.version = "2.0";
                n.queue = [];
                t = b.createElement(e);
                t.async = !0;
                t.src = v;
                s = b.getElementsByTagName(e)[0];
                s.parentNode.insertBefore(t, s);
            })(window, document, "script", "https://connect.facebook.net/en_US/fbevents.js");
            fbq("init", "<?php echo e($pixel->code); ?>");
            fbq("track", "PageView");
        </script>
        <noscript>
            <img height="1" width="1" style="display: none;" src="https://www.facebook.com/tr?id=<?php echo e($pixel->code); ?>&ev=PageView&noscript=1" />
        </noscript>
        <!-- End Facebook Pixel Code -->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php $__currentLoopData = $gtm_code; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gtm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- Google tag (gtag.js) -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-<?php echo e($gtm->code); ?>');</script>
        <!-- End Google Tag Manager -->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    <style>
        .landing_youtube {
            border: 10px solid #000;
            width: 100%;
            height: 500px;
            border-radius: 10px;
        }
        .hover-scale{
            width: 54%;border-color: rgb(255, 255, 255); border-style: solid; border-width: 0px; border-radius: 15px; margin: 0px; display: block; opacity: 1; padding: 10px 40px 6px; background-size: cover; background-color: rgb(222, 25, 25); background-repeat: no-repeat; background-position: center center; background-attachment: scroll; color: rgb(255, 255, 255); font-size: 20px; font-style: normal; text-align: center; font-family: &quot;Hind Siliguri&quot;; font-weight: 600; line-height: 45px; letter-spacing: 0px; text-transform: none; text-decoration: none;
        }
        .hover-scale:hover {
            transform: scale(1.2);
            transition: transform .3s;
        }
        
        .custom-accordion-header {
            padding: 8px 20px;
            font-weight: bold;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: rgb(28, 68, 100);
            color:#fff;
            transition: background-color 0.3s ease;
        }
        
        .custom-accordion-header:hover {
            background-color:  rgb(28, 68, 100);
        }
        
        .custom-accordion-body.show {
            padding: 8px 20px;
            max-height: 500px;
            background: rgb(28, 68, 100);
            border-top: 0;
        }
        
        #textdata{
            background: rgb(202, 209, 223);
            padding: 6px 4px;
            border-radius: 6px;
            color:black; 
        }
        #fromtop{
            box-shadow: rgb(0, 0, 0) 0px 0px 0px 0px inset; border-color: rgb(0, 0, 0); border-style: solid; border-width: 0px; border-radius: 0px; margin: 0px; display: block; padding: 0px; background-size: cover; background-color: rgba(255, 255, 255, 0); background-repeat: no-repeat; background-position: center center; background-attachment: scroll; color: rgb(0, 0, 0); font-size: 27px; font-style: normal; text-align: center; font-family: &quot;Hind Siliguri&quot;; font-weight: 400; line-height: 30px; letter-spacing: 0px; text-transform: none; text-decoration: none;
        }
        .landing_pre{
            text-align: center;
            font-size: 22px;
        }
        #dsf{
            color: rgb(0, 0, 0);
            font-size: 18px;
            font-family: Arial;
            font-weight: 400;
            text-transform: none;
            letter-spacing: 0px;
            font-style: normal;
            text-decoration: none;
            text-align: center;
            line-height: 24px;
            background-color: rgb(228, 255, 237);
            background-size: cover;
            background-position: center center;
            background-attachment: scroll;
            background-repeat: no-repeat;
            border-width: 1px;
            border-style: solid;
            border-color: rgb(95, 230, 140);
            border-radius: 10px;
            box-shadow: rgb(0, 0, 0) 0px 0px 0px 0px inset;
            width: 100%;
        }
        @media only screen and (max-width: 600px) {
            .hover-scale{
                width: 80%;border-color: rgb(255, 255, 255); border-style: solid; border-width: 0px; border-radius: 15px; margin: 0px; display: block; opacity: 1; padding: 0px; background-size: cover; background-color: rgb(222, 25, 25); background-repeat: no-repeat; background-position: center center; background-attachment: scroll; color: rgb(255, 255, 255); font-size: 14px; font-style: normal; text-align: center; font-family: &quot;Hind Siliguri&quot;; font-weight: 600; line-height: 45px; letter-spacing: 0px; text-transform: none; text-decoration: none;
            }
            .h1ww{
                font-size: 20px !important;
                line-height: 24px !important;
            }
            #h1sm{
                font-size: 24px !important;
                line-height: 30px !important;
            }
        }
         
        .package-option {
             
        }
        
        .package-radio {
            display: none !important; /* আসল radio লুকানো */
        }
        
        /* প্রতি কার্ডের ডিফল্ট অবস্থা */
        .package-card {
            cursor: pointer;
            border: 2px solid #d9d9d9;
            border-radius: 8px;
            padding: 10px 14px;
            min-width: max-content;
            text-align: center;
            background: #fff;
            line-height: 1.3;
            transition: all 0.18s ease-in-out;
            user-select: none;
            font-weight: 500;
            color: #111;
            display: flex;
            flex-direction: column;
        }
        
        /* প্রাইস ছোট করে */
        .package-card .package-price {
            font-size: 13px;
            font-weight: 400;
            color: #555;
            margin-top: 2px;
        }
        
        /* hover feel */
        .package-card:hover {
            border-color: #0d6efd33;
            box-shadow: 0 4px 10px rgba(0,0,0,0.06);
        }
        
        /* ✅ SELECTED অবস্থায় কার্ড কেমন হবে:
           radio:checked + label . . .
        */
        .package-radio:checked + .package-card { 
            background: orange;         /* হালকা নীল ব্যাকগ্রাউন্ড */
            box-shadow: 0 0 0 3px rgba(13,110,253,.2);
            color: #fff;
        }
        
        /* selected হলে ভিতরের প্রাইসের রঙও নীল হবে */
        .package-radio:checked + .package-card .package-price {
            color: #0d6efd;
        }
        

    </style>

</head>

<body>
    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php
$productImage = App\Models\ProductImage::where(
    'product_id',
    $product->id,
)->first();
    ?>
    <section>
        <div class="pb-0 pt-3" style="background: #e3e5ff">
            <div class="container">
                
                <div class="text-center mt-3">
                    <a href="<?php echo e(url('/')); ?>">
                        <img src="<?php echo e(asset($campaign_data->image_one)); ?>" alt="" width="250">
                    </a>
                    <h2 class="my-4 fw-bold" style="color:#000 !important"><?php echo e($campaign_data->name); ?></h2>
                    <h4 class="my-3 mb-2 fw-bold" style="color:#132a8c !important"><?php echo e($campaign_data->banner_title); ?></h4>
                </div>
            </div>
            
            
            <?php if($campaign_data->video): ?>
                <div class="container pt-5">
                    <div class="row ">
                        <div class="col-12 ">
                            <iframe width="100%" class="landing_youtube" height="315"
                                src="https://www.youtube.com/embed/<?php echo e($campaign_data->video); ?>" title="YouTube video player"
                                frameborder="0"
                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                        </div>
                    </div>
                    <br>
                    
                    <div class="row">
                        <div class="col-12" style="text-align: -webkit-center;">
                            <a href="#order_form" class="hover-scale"><!----> হোম ডেলিভারি ফ্রি অফারে অর্ডার করুন। <!----></a>
                        </div>
                    </div>
                    <br>
                    
                </div>
            <?php endif; ?>
            
            
            <div style="background: #fff">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-12">
                            <h1 class="h1ww" style="margin: 0px; display: block; padding-top: 20px; padding-bottom: 20px; background-size: cover; background-color: rgba(13, 186, 225, 0); background-repeat: no-repeat; background-position: center center; background-attachment: scroll; color: rgb(0, 0, 255); font-size: 30px; font-style: normal; text-align: center; font-family: &quot;Hind Siliguri&quot;; font-weight: 700; line-height: 60px; letter-spacing: 0px; text-transform: none; text-decoration: none;"><?php echo e($campaign_data->middle_text); ?></h1>
                             
                        </div>
                        <div class="col-md-12 col-12 p-0">
                            <div class="home-slider-container mt-3">
                                <div class="landing_slider owl-carousel">
                                    <?php $__currentLoopData = App\Models\LandingBanner::where('campaign_id', $campaign_data->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="slider-item landing-slider-item d-flex justify-content-center">
                                            <img class="img-fluid" src="<?php echo e(asset($value->image)); ?>" alt="" />
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class=" d-flex justify-content-center my-3x">
                    <a href="#order_form" class="order-button mb-4">
                        <i class="fas fa-shopping-cart"></i> অর্ডার করতে এখানে ক্লিক করুন 
                    </a>
                </div>
            </div>
            
         
            
        </div>

        <div style="background: #f7f7f7" class="py-4"> 
            <div class="container"> 
                <div>
                    <b><h3 style="margin: 0px; display: block; padding-top: 20px; padding-bottom: 20px; background-size: cover; background-color: rgba(13, 186, 225, 0); background-repeat: no-repeat; background-position: center center; background-attachment: scroll; color: rgb(0, 0, 255); font-size: 40px; font-style: normal; text-align: center; font-family: &quot;Hind Siliguri&quot;">✨এই হিজাবটি কিভাবে আপনাকে হেল্প করবে?</3></b>
                </div>
                <p class="my-3">
                    <?php echo $campaign_data->description; ?>

                </p>
            </div>
            <div class=" d-flex justify-content-center my-3">
                <a href="#order_form" class="order-button">
                    <i class="fas fa-shopping-cart"></i> অর্ডার করতে চাই
                </a>
            </div>


            

        </div>
        <div style="background: #fff;">
            <div class="container">
                <div class="landingp_title">
                    <h3> কাস্টমারদের রিভিও</h3>
                </div>
                <div class="home-slider-container mt-3">
                    <div class="landing_review_slider owl-carousel">
                        <?php $__currentLoopData = App\Models\CampaignReview::where('campaign_id', $campaign_data->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="slider-item landing-slider-item">
                                <img class="img-fluid" src="<?php echo e(asset($value->image)); ?>" alt="" />
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
         

        <?php if($campaign_data->faq_question_one): ?>
            <div class="container">
                <div>
                    <h3 style="margin: 0px; display: block; padding-top: 20px; padding-bottom: 20px; background-size: cover; background-color: rgba(13, 186, 225, 0); background-repeat: no-repeat; background-position: center center; background-attachment: scroll; color: rgb(0, 0, 255); font-size: 45px; font-style: normal; text-align: center; font-family: &quot;Hind Siliguri&quot;; font-weight: 700; line-height: 60px; letter-spacing: 0px; text-transform: none; text-decoration: none;">কিছু জিজ্ঞাসা👇</h3>
                </div>
                <div class="custom-accordion" id="faqAccordion">
                    
                    <!-- Accordion Item -->
                    <?php if($campaign_data->faq_question_one): ?>
                        <div class="custom-accordion-item">
                            <div class="custom-accordion-header collapsed" data-bs-toggle="collapse" data-bs-target="#faq1">
                                <?php echo e($campaign_data->faq_question_one); ?>

                                <span class="custom-icon">&#9656;</span>
                            </div>
                            <div id="faq1" class="custom-accordion-body collapse show" data-bs-parent="#faqAccordion">
                                <div id="textdata">
                                    <?php echo $campaign_data->faq_answar_one; ?>

                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($campaign_data->faq_question_two): ?>
                        <div class="custom-accordion-item">
                            <div class="custom-accordion-header collapsed" data-bs-toggle="collapse" data-bs-target="#faq2">
                                <?php echo e($campaign_data->faq_question_two); ?>

                                <span class="custom-icon">&#9656;</span>
                            </div>
                            <div id="faq2" class="custom-accordion-body collapse show" data-bs-parent="#faqAccordion">
                                <div id="textdata">
                                <?php echo $campaign_data->faq_answar_two; ?>

                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($campaign_data->faq_question_three): ?>
                        <div class="custom-accordion-item">
                            <div class="custom-accordion-header collapsed" data-bs-toggle="collapse" data-bs-target="#faq3">
                                <?php echo e($campaign_data->faq_question_three); ?>

                                <span class="custom-icon">&#9656;</span>
                            </div>
                            <div id="faq3" class="custom-accordion-body collapse show" data-bs-parent="#faqAccordion">
                                <div id="textdata">
                                <?php echo $campaign_data->faq_answar_three; ?>

                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($campaign_data->faq_question_four): ?>
                        <div class="custom-accordion-item">
                            <div class="custom-accordion-header collapsed" data-bs-toggle="collapse" data-bs-target="#faq4">
                                <?php echo e($campaign_data->faq_question_four); ?>

                                <span class="custom-icon">&#9656;</span>
                            </div>
                            <div id="faq4" class="custom-accordion-body collapse show" data-bs-parent="#faqAccordion">
                                <div id="textdata">
                                <?php echo $campaign_data->faq_answar_four; ?>

                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if($campaign_data->faq_question_five): ?>
                        <div class="custom-accordion-item">
                            <div class="custom-accordion-header collapsed" data-bs-toggle="collapse" data-bs-target="#faq5">
                                <?php echo e($campaign_data->faq_question_five); ?>

                                <span class="custom-icon">&#9656;</span>
                            </div>
                            <div id="faq5" class="custom-accordion-body collapse show" data-bs-parent="#faqAccordion">
                                <div id="textdata">
                                <?php echo $campaign_data->faq_answar_five; ?>

                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>

        <div style="background: #FEFFDD">
            <div class="container">
                <div class="landing_pre">
                    <p id="fromtop">
                        <p><strong>রেগুলার প্রাইস:</strong><span style="color: rgb(243, 18, 18)"><strong><s><?php echo e($product->old_price); ?></s></strong></span><strong> টাকা।</strong></p>
                        <p><strong>স্পেশাল অফার প্রাইস এখন:</strong><span style="color: rgb(8, 210, 4)"><strong> ৳<?php echo e($product->new_price); ?></strong></span><strong> টাকা।</strong></p>
                        <p><span style="color: #0b2eda"><strong>সিমিত সময়ের জন্য হোম ডেলিভারি ফ্রি!</strong></span></p>
                        <h1 id="h1sm" style="margin: 0px; display: block; padding-top: 15px; padding-bottom: 10px; background-size: cover; background-color: rgba(245, 207, 10, 0); background-repeat: no-repeat; background-position: center center; background-attachment: scroll; color: rgb(0, 0, 0); font-size: 40px; font-style: normal; text-align: center; font-family: &quot;Hind Siliguri&quot;; font-weight: 700; line-height: 60px; letter-spacing: 0px; text-transform: none; text-decoration: none;"><!----> <a href="tel:+8801315607052">💢 প্রয়োজনে কল করুন-8801315607052💢 </a><!----></h1>
                    </p>
                </div>
            </div>
        </div>

        
        <form action="<?php echo e(route('landingpage.ordersave')); ?>" method="POST" id="order_form">
            <?php echo csrf_field(); ?>
            <div class="container mx-auto my-5" style="border-color: rgb(0, 0, 0);border-style: groove;border-width: 15px 4px;border-radius: 30px;">
                <div>
                    <div class="row">
                        <div class="col-12">
                            <h1 class="my-4 text-center landing_form_title" style="color:black;font-weight:bold;">অর্ডার করতে আপনার সঠিক ইনফরমেশন দিয়ে ফর্মটি সম্পূর্ণ পূরণ করুন</h1>
                            <h1 class="my-4 text-center landing_form_title" style="color:red;font-weight:bold;">অগ্রীম টাকা দেওয়ার ঝামেলা ছাড়াই অর্ডার করুন। প্রোডাক্ট হাতে পেয়ে চেক করে টাকা দিন।</h1>
                        </div>
                        
                            <?php if($product->type == 1): ?>
                                <div class="py-1">
                                    <!--<h5 class="fw-bold mb-4"><?php echo e($campaign_data->review ? $campaign_data->review : 'কোন প্যাকেজটি নিতে চান সিলেক্ট করুন'); ?></h5>-->
                                    <div class="my-3">
                                        <div class="row">
                                            <?php $__currentLoopData = $productcolors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-lg-6">
                                                    <div class="form-check d-inline-block me-3 mb-2" id="dsf">
                                                        <label class="form-check-label d-flex align-items-center p-2" style="cursor: pointer;">
                                                            <input class="form-check-input me-2 mb-2" type="radio" name="color"
                                                                value="<?php echo e($value->color); ?>"
                                                                <?php echo e($loop->first ? 'checked' : ''); ?>>
                                                                <div class="landing_variant_product"> 
                                                                    <img src="<?php echo e(asset($value->Image)); ?>" alt="" class="img-fluid" style="width:80px;height:auto"> 
                                                                </div>
                                                                <span style="text-align: left;padding-left: 15px;padding-right: 15px;">
                                                                    <b>
                                                                        <?php echo e($value->color); ?>

                                                                    </b> 
                                                                </span> 
                                                        </label>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                    <?php if(isset($product->pro_unit)): ?>
                                    <label class="mb-2">
                                        <b>Select Your লং:</b> <span style="font-size:22px;color:red"><b><?php echo e($product->pro_unit); ?></b></span>
                                    </label>
                                    <?php endif; ?>
                                    
                                    <div class="col-12">
                                        <div class="package-wrapper d-flex flex-wrap gap-2">
                                            <?php $__currentLoopData = $productsizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="form-check package-option m-0 p-0">
                                                    <input
                                                        class="form-check-input d-none package-radio"
                                                        type="radio"
                                                        name="package"
                                                        id="package_<?php echo e($key); ?>"
                                                        value="<?php echo e($value->size); ?>"
                                                        data-price="<?php echo e($value->SalePrice); ?>"
                                                        <?php echo e($loop->first ? 'checked' : ''); ?>

                                                    >
                                    
                                                    <label class="form-check-label package-card" for="package_<?php echo e($key); ?>">
                                                        <div class="package-label"><?php echo e($value->size); ?></div> 
                                                    </label>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        
                                        <?php if(count($productsigments) == 0): ?>
                                        <?php else: ?>
                                            <h6 class="mb-2"><b>সিলেক্ট করে কনফার্ম করুন :</b></h6>
                                            <div class="pro-size d-flex" style="width: 100%;">
                                                
                                                <div class="size_inner">
                                                    <div class="size-container">
                                                        <div class="selector">
                                                            <?php $__currentLoopData = $productsigments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productsigment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="selector-item">
                                                                    <input type="radio" id="sig-option<?php echo e($productsigment->id); ?>"
                                                                        value="<?php echo e($productsigment->weight); ?>" name="product_sigment"
                                                                        class="selector-item_radio emptyalert"
                                                                         />
                                                                    <label style="padding:0px 8px"
                                                                        for="sig-option<?php echo e($productsigment->id); ?>" id="sigoption<?php echo e($productsigment->id); ?>"
                                                                        onclick="setpricesig('<?php echo e($productsigment->weight); ?>',<?php echo e($productsigment->SalePrice); ?>,<?php echo e($productsigment->id); ?>)"
                                                                        class="selector-item_label"><?php echo e($productsigment->weight); ?></label>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    

                                </div>
                            <?php elseif($product->type == 0): ?>
                                <div class="py-5">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="package"
                                            id="package_single" value="<?php echo e($product->id); ?>"
                                            data-price="<?php echo e($product->new_price); ?>" checked>

                                        <label class="form-check-label w-100" for="package_single">
                                            <div class="package-card">
                                                <div class="package-label text-dark"><?php echo e($product->name); ?> </div>
                                                <div class="price"><del class="text-danger">৳ <?php echo e($product->old_price); ?></del> ৳ <?php echo e($product->new_price); ?></div>
                                            </div>
                                        </label>
                                    </div>
                                </div>

                            <?php endif; ?>
                            
                    </div>
                    <div class="row mb-3">
                        <div class="col-12 col-md-6 px-4 mb-4">
                            <h4 class="mt-3">Billing Details</h4>
                            <div class="mt-3">
                                <label class="form-label">আপনার নাম লিখুন *</label>
                                <input type="text" class="form-control" placeholder="আপনার নাম লিখুন " name="name">
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mt-3">
                                <label class="form-label">আপনার ঠিকানা লিখুন *</label>
                                <input type="text" class="form-control" placeholder="বাড়ি নং, রোড নং, থানা, জেলা"
                                    name="address">
                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mt-3">
                                <label class="form-label">আপনার মোবাইল নাম্বারটি লিখুন *</label>
                                <input type="text" class="form-control" placeholder="আপনার মোবাইল নাম্বারটি লিখু" name="phone">
                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <h5 class="mt-4 mb-3">Shipping</h5>
                            <div class="table-responsive">
                                <table class="table table-bordered align-middle bg-white">
                                    <tbody>
                                        <?php $__currentLoopData = $shippingcharge; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td style="width: 80%;">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="radio"
                                                            name="shipping" id="shipping_<?php echo e($key); ?>"
                                                            data-amount="<?php echo e($value->amount); ?>"
                                                            <?php echo e($loop->first ? 'checked' : ''); ?>

                                                            value="<?php echo e($value->amount); ?>">
                                                        <label class="form-check-label"
                                                            for="shipping_<?php echo e($key); ?>">
                                                            <?php echo e($value->name); ?>

                                                        </label>
                                                    </div>
                                                </td>
                                                <td class="text-end">৳ <?php echo e($value->amount); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                    </tbody>
                                </table>
                            </div>

                            

                           
                        </div>

                        <!-- Your Order -->
                        <?php
// $defaultPackage = $productsizes[0];
// $defaultShipping = $shippingcharge[0];

$defaultPackage =
    $product->type == 1 && isset($productsizes[0])
    ? $productsizes[0]
    : (object) ['SalePrice' => $product->new_price];
$defaultShipping = isset($shippingcharge[0])
    ? $shippingcharge[0]
    : (object) ['amount' => 0];
                        ?>

                        <div class="col-12 col-md-6 px-4">
                            <h4 class="my-3 fs-6 fw-bold">আপনার অর্ডার</h4>

                            <div class="order-summary">
                                <div class="d-flex justify-content-between mb-2">
                                    <strong>Product</strong>
                                    <strong>Subtotal</strong>
                                </div>

                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <div class="d-flex align-items-center">

                                        <img src="<?php echo e(asset($productImage->image)); ?>" class="product-img me-2"
                                            alt="" style="width: 50px;height:auto;border-radius:8px;">
                                        <div>
                                            <?php echo e($product->name); ?>

                                            <br>
                                            
                                            <div class="input-group mt-1" style="width: 120px;">
                                                <button type="button" class="btn btn-outline-secondary btn-sm"
                                                    id="decreaseQty">−</button>
                                                <input type="text" class="form-control form-control-sm text-center"
                                                    value="1" id="quantity" name="quantity" readonly>
                                                <button type="button" class="btn btn-outline-secondary btn-sm"
                                                    id="increaseQty">+</button>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                    <input type="hidden" name="product_name" value="<?php echo e($product->name); ?>">
                                    <input type="hidden" name="product_price" id="inputProductPrice"
                                        value="<?php echo e($defaultPackage->SalePrice); ?>">
                                    <input type="hidden" name="subtotal" id="inputSubtotal"
                                        value="<?php echo e($defaultPackage->SalePrice); ?>">
                                    <input type="hidden" name="total" id="inputTotal"
                                        value="<?php echo e($defaultPackage->SalePrice + $defaultShipping->amount); ?>">

                                    <div>৳ <span id="productPrice"><?php echo e($defaultPackage->SalePrice); ?></span></div>
                                </div>

                                <hr>
                                <div class="d-flex justify-content-between mb-2">
                                    <strong>Subtotal</strong>
                                    <strong>৳ <span id="subtotal"><?php echo e($defaultPackage->SalePrice); ?></span></strong>
                                </div>
                                <div class="d-flex justify-content-between mb-2">
                                    <strong>Shipping Charge</strong>
                                    <strong>৳ <span id="shippingCharge"><?php echo e($defaultShipping->amount); ?></span></strong>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between mb-3">
                                    <strong>Total</strong>
                                    <strong>৳ <span
                                            id="total"><?php echo e($defaultPackage->SalePrice + $defaultShipping->amount); ?></span></strong>
                                </div>

                                <div class="p-2 rounded mb-2" style="background: #F7F7F7">
                                    <p class="mb-0 mt-2 text-dark">পণ্য হাতে পেয়ে মূল্য পরিশোধ করুন</p>
                                </div>

                                <button class="place-order-btn btn btn-dark w-100 fw-bold" style="background: #015466">
                                    <i class="bi bi-lock"></i> অর্ডার কনফার্ম করুন ৳ <span
                                        id="btnTotal"><?php echo e($defaultPackage->SalePrice + $defaultShipping->amount); ?></span>
                                </button>
                            </div>
                        </div>


                        
                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                let packageRadios = document.querySelectorAll('input[name="package"]');
                                let shippingRadios = document.querySelectorAll('input[name="shipping"]');
                                let productPriceSpan = document.getElementById('productPrice');
                                let subtotalSpan = document.getElementById('subtotal');
                                let shippingSpan = document.getElementById('shippingCharge');
                                let totalSpan = document.getElementById('total');
                                let btnTotalSpan = document.getElementById('btnTotal');
                                let quantityInput = document.getElementById('quantity');
                                let btnIncrease = document.getElementById('increaseQty');
                                let btnDecrease = document.getElementById('decreaseQty');


                                function getSelectedPackagePrice() {
                                    let selected = document.querySelector('input[name="package"]:checked');
                                    // return parseFloat(selected?.dataset.price || 0);
                                    return parseFloat($('#inputProductPrice').val());
                                }

                                function getSelectedShippingCharge() {
                                    let selected = document.querySelector('input[name="shipping"]:checked');
                                    return parseFloat(selected?.dataset.amount || 0);
                                }

                                function getQuantity() {
                                    return parseInt(quantityInput.value) || 1;
                                }

                                function updateTotals() {
                                    let unitPrice = getSelectedPackagePrice();
                                    let qty = getQuantity();
                                    let subtotal = unitPrice * qty;
                                    let shipping = getSelectedShippingCharge();
                                    let total = subtotal + shipping;

                                    productPriceSpan.textContent = unitPrice;
                                    subtotalSpan.textContent = subtotal;
                                    shippingSpan.textContent = shipping;
                                    totalSpan.textContent = total;
                                    btnTotalSpan.textContent = total;

                                    document.getElementById('inputProductPrice').value = unitPrice;
                                    document.getElementById('inputSubtotal').value = subtotal;
                                    document.getElementById('inputTotal').value = total;
                                }

                                // Event listeners
                                packageRadios.forEach(radio => {
                                    radio.addEventListener('change', updateTotals);
                                });

                                shippingRadios.forEach(radio => {
                                    radio.addEventListener('change', updateTotals);
                                });

                                btnIncrease.addEventListener('click', function() {
                                    let qty = getQuantity();
                                    quantityInput.value = qty + 1;
                                    updateTotals();
                                });

                                btnDecrease.addEventListener('click', function() {
                                    let qty = getQuantity();
                                    if (qty > 1) {
                                        quantityInput.value = qty - 1;
                                        updateTotals();
                                    }
                                });

                                // Initial calculation
                                updateTotals();
                            });
                        </script>
                    </div>
                </div>
            </div>
        </form>


        <div style="background: #E2F7E1">
            <div class="container py-2">
                <div style="background:#DCFFF5; border-radius: 10px;">
                    <div class="p-2">
                        <h2 class="fw-bold text-center" style="color: #FF6700">যেকোন প্রয়োজনে কল করুন</h2>
                        <div class=" d-flex justify-content-center my-3">

                                <a class="order-button" href="tel:+8801315607052" target="_blank">📞+8801315607052</a>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div style="background: #71b2ec; padding:8px">
            <p class="fw-bold text-center text-white">© 2025 <?php echo e(env('APP_NAME')); ?> All Rights Reserved. Developed By <a href="https://webthemeapp.com">WebThemeaApp</a></p>
        </div>
    </section>

    
    <div>
        <a href="tel:<?php echo e($contact->phone); ?>" target="_blank"
            style="position: fixed; bottom: 130px; right: 20px; z-index: 111;">
            <svg width="39" height="39" viewBox="0 0 39 39" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="rgb(3, 35, 231)">
                </circle>
                <path
                    d="M19.3929 14.9176C17.752 14.7684 16.2602 14.3209 14.7684 13.7242C14.0226 13.4259 13.1275 13.7242 12.8292 14.4701L11.7849 16.2602C8.65222 14.6193 6.11623 11.9341 4.47529 8.95057L6.41458 7.90634C7.16046 7.60799 7.45881 6.71293 7.16046 5.96705C6.56375 4.47529 6.11623 2.83435 5.96705 1.34259C5.96705 0.596704 5.22117 0 4.47529 0H0.745882C0.298353 0 0 0.298352 0 0.745881C0 3.72941 0.596704 6.71293 1.93929 9.3981C3.87858 13.575 7.30964 16.8569 11.3374 18.7962C14.0226 20.1388 17.0061 20.7355 19.9896 20.7355C20.4371 20.7355 20.7355 20.4371 20.7355 19.9896V16.4094C20.7355 15.5143 20.1388 14.9176 19.3929 14.9176Z"
                    transform="translate(9.07179 9.07178)" fill="white"></path>
            </svg>
        </a>

        <a href="https://wa.me/+88<?php echo e($contact->phone); ?>" target="_blank"
            style="position: fixed;bottom: 70px;right: 20px;z-index:111">
            <svg width="39" height="39" viewBox="0 0 39 39" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <circle class="color-element" cx="19.4395" cy="19.4395" r="19.4395" fill="#49E670"></circle>
                <path
                    d="M12.9821 10.1115C12.7029 10.7767 11.5862 11.442 10.7486 11.575C10.1902 11.7081 9.35269 11.8411 6.84003 10.7767C3.48981 9.44628 1.39593 6.25317 1.25634 6.12012C1.11674 5.85403 2.13001e-06 4.39053 2.13001e-06 2.92702C2.13001e-06 1.46351 0.83755 0.665231 1.11673 0.399139C1.39592 0.133046 1.8147 1.01506e-06 2.23348 1.01506e-06C2.37307 1.01506e-06 2.51267 1.01506e-06 2.65226 1.01506e-06C2.93144 1.01506e-06 3.21063 -2.02219e-06 3.35022 0.532183C3.62941 1.19741 4.32736 2.66092 4.32736 2.79397C4.46696 2.92702 4.46696 3.19311 4.32736 3.32616C4.18777 3.59225 4.18777 3.59224 3.90858 3.85834C3.76899 3.99138 3.6294 4.12443 3.48981 4.39052C3.35022 4.52357 3.21063 4.78966 3.35022 5.05576C3.48981 5.32185 4.18777 6.38622 5.16491 7.18449C6.42125 8.24886 7.39839 8.51496 7.81717 8.78105C8.09636 8.91409 8.37554 8.9141 8.65472 8.648C8.93391 8.38191 9.21309 7.98277 9.49228 7.58363C9.77146 7.31754 10.0507 7.1845 10.3298 7.31754C10.609 7.45059 12.2841 8.11582 12.5633 8.38191C12.8425 8.51496 13.1217 8.648 13.1217 8.78105C13.1217 8.78105 13.1217 9.44628 12.9821 10.1115Z"
                    transform="translate(12.9597 12.9597)" fill="#FAFAFA"></path>
                <path
                    d="M0.196998 23.295L0.131434 23.4862L0.323216 23.4223L5.52771 21.6875C7.4273 22.8471 9.47325 23.4274 11.6637 23.4274C18.134 23.4274 23.4274 18.134 23.4274 11.6637C23.4274 5.19344 18.134 -0.1 11.6637 -0.1C5.19344 -0.1 -0.1 5.19344 -0.1 11.6637C-0.1 13.9996 0.624492 16.3352 1.93021 18.2398L0.196998 23.295ZM5.87658 19.8847L5.84025 19.8665L5.80154 19.8788L2.78138 20.8398L3.73978 17.9646L3.75932 17.906L3.71562 17.8623L3.43104 17.5777C2.27704 15.8437 1.55796 13.8245 1.55796 11.6637C1.55796 6.03288 6.03288 1.55796 11.6637 1.55796C17.2945 1.55796 21.7695 6.03288 21.7695 11.6637C21.7695 17.2945 17.2945 21.7695 11.6637 21.7695C9.64222 21.7695 7.76778 21.1921 6.18227 20.039L6.17557 20.0342L6.16817 20.0305L5.87658 19.8847Z"
                    transform="translate(7.7758 7.77582)" fill="white" stroke="white" stroke-width="0.2"></path>
            </svg>
        </a>
    </div>
    
      <style>
            /* Overlay Background */
            .popup-overlay {
                position: fixed;
                inset: 0;
                /*background-color: rgba(0, 0, 0, 0.5);*/
                z-index: 999;
                display: flex;
                align-items: center;
                justify-content: center;
            }

            /* Popup Box */
            .popup {
                position: relative;
                background: #fff;
                border-radius: 8px;
                max-width: 90%;
                max-height: 90%;
                padding: 20px;
                box-shadow: 0 0 20px rgba(0, 0, 0, 0.2);
                animation: fadeIn 0.4s ease-in-out;
            }

            /* Close Button */
            .popup .close-btn {
                position: absolute;
                top: 10px;
                right: 14px;
                font-size: 24px;
                font-weight: bold;
                color: #333;
                cursor: pointer;
                background: none;
                border: none;
            }

            .popup img {
                max-width: 100%;
                height: auto;
                border-radius: 6px;
            }

            @keyframes fadeIn {
                from {
                    opacity: 0;
                    transform: scale(0.95);
                }

                to {
                    opacity: 1;
                    transform: scale(1);
                }
            }
            .popup_long_Image{
                width: 400px; 
                height:400px;
                object-fit: contain;
            }
            @media only screen and (min-width:320px) and (max-width:767px) {
                .popup_long_Image{
                height:340px;
            }
        </style>
        <?php
        $setting = App\Models\GeneralSetting::first();
        ?>
        <!-- Popup Overlay -->
        <!--<?php if($setting->popup_image): ?>-->
        <!--    <div id="popupOverlay" class="popup-overlay mt-5" style="display: none; z-index: 9999;">-->
        <!--        <div class="popup">-->
        <!--            <div class="text-center">-->
        <!--                <img src="<?php echo e(asset($setting->white_logo)); ?>" alt="" width="80">-->
        <!--            </div>-->
        <!--            <button class="close-btn fs-1" onclick="closePopup()" style="width: 50px">&times; </button>-->
        <!--            <hr>-->
        <!--            <a href="<?php echo e($setting->popup_link); ?>" onclick="markPopupAsClicked()">-->
        <!--                <img src="<?php echo e(asset($setting->popup_image)); ?>" style="" class="popup_long_Image" alt="Popup Image" />-->
        <!--            </a>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--<?php endif; ?>-->
        
        <script>
            
            function setpricesig(sigment, regp,id) {
                console.log(sigment);
                $('#inputProductPrice').val(regp);
                $('.selector-item_label').css('background','white');
                $('#sigoption'+id).css('background','orange');
                
                $('#productPrice').html(regp);
                qty =$('#quantity').val();
                var sub=qty*regp;
                $('#inputSubtotal').val(sub);
                
                $('#subtotal').html(sub);
                var dv=$('#shippingCharge').html();
                var total=sub+parseInt(dv);
                $('#total').html(total);
                $('#inputTotal').val(total);
                
            }
            
            function closePopup() {
                document.getElementById("popupOverlay").style.display = "none";
                sessionStorage.setItem("popupClosed", "true"); // Mark as closed
            }
        
            function markPopupAsClicked() {
                // Mark the popup as clicked so it doesn't show again after clicking the link
                sessionStorage.setItem("popupClosed", "true");
            }
        
            window.onload = function () {
                const popup = document.getElementById("popupOverlay");
        
                // Only show the popup if it has not been closed yet
                if (!sessionStorage.getItem("popupClosed")) {
                    popup.style.display = "flex"; // Show the popup
                }
            };
            
            function showmessage(){
                $('#showm').css('display','none');
                $('#showms').css('display','none');
                $('#crossms').css('display','inline');
                $('#crossm').css('display','inline');
                $("#message").fadeIn('slow');
            }
            function hidemessage(){
                $('#showm').css('display','inline');
                $('#showms').css('display','inline');
                $('#crossms').css('display','none');
                $('#crossm').css('display','none');
                $("#message").fadeOut('slow');
            }
            
        </script>

    <script src="<?php echo e(asset('public/frontEnd/campaign/js')); ?>/jquery-2.1.4.min.js"></script>
    <script src="<?php echo e(asset('public/frontEnd/campaign/js')); ?>/all.js"></script>
    <script src="<?php echo e(asset('public/frontEnd/campaign/js')); ?>/bootstrap.min.js"></script>
    <script src="<?php echo e(asset('public/frontEnd/campaign/js')); ?>/owl.carousel.min.js"></script>
    <script src="<?php echo e(asset('public/frontEnd/campaign/js')); ?>/select2.min.js"></script>
    <script src="<?php echo e(asset('public/frontEnd/campaign/js')); ?>/script.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script type="text/javascript">
        // Clear the previous ecommerce object.
        dataLayer.push({ ecommerce: null });

        // Push the begin_checkout event to dataLayer.
        dataLayer.push({
            event: "begin_checkout",
            ecommerce: {
                currency: "BDT",
                value: Number($('#btnTotal').text()),
                items: [<?php $__currentLoopData = Cart::instance('shopping')->content(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        item_name: "<?php echo e($cartInfo->name); ?>",
                        item_id: "<?php    echo $cartInfo->id?>",
                        price: Number("<?php    echo $cartInfo->price?>"),
                        item_brand: "<?php echo e($cartInfo->options->brands); ?>",
                        item_category: "<?php echo e($cartInfo->options->category); ?>",
                        item_size: "<?php echo e($cartInfo->options->size); ?>",
                        item_color: "<?php echo e($cartInfo->options->color); ?>",
                        currency: "BDT",
                        quantity: <?php echo e($cartInfo->qty ?? 0); ?>

                    },
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
            }
        });
    </script>

    <!-- bootstrap js -->
    <script>
        $(document).ready(function() {
            $(".landing_slider").owlCarousel({
                margin: 20,
                items: 4,
                loop: true,
                dots: true,
                autoplay: true,
                nav: true,
                autoplayHoverPause: false,
                margin: 0,
                mouseDrag: true,
                smartSpeed: 1500,
                autoplayTimeout: 4000,

                navText: ["<i class='fa-solid fa-angle-left'></i>",
                    "<i class='fa-solid fa-angle-right'></i>"
                ],
                responsive: {
                    0: {
                        items: 1,
                        margin: 10
                    },
                    600: {
                        items: 2,
                        margin: 15
                    },
                    1000: {
                        items: 3,
                        margin: 20
                    }
                }
            });

            $(".landing_review_slider").owlCarousel({
                margin: 20,
                items: 4,
                loop: true,
                dots: true,
                autoplay: true,
                nav: true,
                autoplayHoverPause: false,
                margin: 0,
                mouseDrag: true,
                smartSpeed: 1500,
                autoplayTimeout: 4000,

                navText: ["<i class='fa-solid fa-angle-left'></i>",
                    "<i class='fa-solid fa-angle-right'></i>"
                ],
                responsive: {
                    0: {
                        items: 1,
                        margin: 10
                    },
                    600: {
                        items: 2,
                        margin: 15
                    },
                    1000: {
                        items: 3,
                        margin: 20
                    }
                }
            });

            $(".owl-carousel").owlCarousel({
                margin: 15,
                loop: true,
                dots: false,
                autoplay: true,
                autoplayTimeout: 6000,
                autoplayHoverPause: true,
                items: 1,
            });
            $('.owl-nav').remove();
        });
    </script>
    <script>
        $(document).ready(function() {
            $('.select2').select2();
        });
    </script>
    <script>
        $("#area").on("change", function() {
            var id = $(this).val();
            $.ajax({
                type: "GET",
                data: {
                    id: id
                },
                url: "<?php echo e(route('shipping.charge')); ?>",
                dataType: "html",
                success: function(response) {
                    $('.cartlist').html(response);
                }
            });
        });
    </script>
    <script>
        $(".cart_remove").on("click", function() {
            var id = $(this).data("id");
            $("#loading").show();
            if (id) {
                $.ajax({
                    type: "GET",
                    data: {
                        id: id
                    },
                    url: "<?php echo e(route('cart.remove')); ?>",
                    success: function(data) {
                        if (data) {
                            $(".cartlist").html(data);
                            $("#loading").hide();
                            return cart_count() + mobile_cart() + cart_summary();
                        }
                    },
                });
            }
        });
        $(".cart_increment").on("click", function() {
            var id = $(this).data("id");
            $("#loading").show();
            if (id) {
                $.ajax({
                    type: "GET",
                    data: {
                        id: id
                    },
                    url: "<?php echo e(route('cart.increment')); ?>",
                    success: function(data) {
                        if (data) {
                            $(".cartlist").html(data);
                            $("#loading").hide();
                            return cart_count() + mobile_cart();
                        }
                    },
                });
            }
        });

        $(".cart_decrement").on("click", function() {
            var id = $(this).data("id");
            $("#loading").show();
            if (id) {
                $.ajax({
                    type: "GET",
                    data: {
                        id: id
                    },
                    url: "<?php echo e(route('cart.decrement')); ?>",
                    success: function(data) {
                        if (data) {
                            $(".cartlist").html(data);
                            $("#loading").hide();
                            return cart_count() + mobile_cart();
                        }
                    },
                });
            }
        });
    </script>
    <script>
        $('.review_slider').owlCarousel({
            dots: false,
            arrow: false,
            autoplay: true,
            loop: true,
            margin: 10,
            smartSpeed: 1000,
            mouseDrag: true,
            touchDrag: true,
            items: 6,
            responsiveClass: true,
            responsive: {
                300: {
                    items: 1,
                },
                480: {
                    items: 2,
                },
                768: {
                    items: 5,
                },
                1170: {
                    items: 5,
                },
            }
        });
    </script>

    <script>
        $('.campro_img_slider').owlCarousel({
            dots: false,
            arrow: false,
            autoplay: true,
            loop: true,
            margin: 10,
            smartSpeed: 1000,
            mouseDrag: true,
            touchDrag: true,
            items: 3,
            responsiveClass: true,
            responsive: {
                300: {
                    items: 1,
                },
                480: {
                    items: 2,
                },
                768: {
                    items: 3,
                },
                1170: {
                    items: 3,
                },
            }
        });
    </script>

</body>

</html>
<?php /**PATH /home/u720163010/domains/altaqwawear.com/public_html/resources/views/frontEnd/layouts/pages/campaign/campaign.blade.php ENDPATH**/ ?>